/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.DataFile;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.apache.activemq.util.LinkedNode;

class DataFileAppender {
    protected static final byte[] RESERVED_SPACE = new byte[21];
    protected static final String SHUTDOWN_COMMAND = "SHUTDOWN";
    protected final AsyncDataManager dataManager;
    protected final Map<WriteKey, WriteCommand> inflightWrites;
    protected final Object enqueueMutex = new Object(){};
    protected WriteBatch nextWriteBatch;
    protected boolean shutdown;
    protected IOException firstAsyncException;
    protected final CountDownLatch shutdownDone = new CountDownLatch(1);
    protected int maxWriteBatchSize = 0x400000;
    private boolean running;
    private Thread thread;

    public DataFileAppender(AsyncDataManager dataManager) {
        this.dataManager = dataManager;
        this.inflightWrites = this.dataManager.getInflightWrites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location storeItem(ByteSequence data, byte type, boolean sync) throws IOException {
        WriteBatch batch;
        int size = data.getLength() + 32;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        WriteCommand write = new WriteCommand(location, data, sync);
        DataFileAppender dataFileAppender = this;
        synchronized (dataFileAppender) {
            DataFile dataFile = this.dataManager.allocateLocation(location);
            batch = this.enqueue(dataFile, write);
        }
        location.setLatch(batch.latch);
        if (sync) {
            try {
                batch.latch.await();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        } else {
            this.inflightWrites.put(new WriteKey(location), write);
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location storeItem(ByteSequence data, byte type, Runnable onComplete) throws IOException {
        WriteBatch batch;
        int size = data.getLength() + 32;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        WriteCommand write = new WriteCommand(location, data, onComplete);
        DataFileAppender dataFileAppender = this;
        synchronized (dataFileAppender) {
            DataFile dataFile = this.dataManager.allocateLocation(location);
            batch = this.enqueue(dataFile, write);
        }
        location.setLatch(batch.latch);
        this.inflightWrites.put(new WriteKey(location), write);
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteBatch enqueue(DataFile dataFile, WriteCommand write) throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            WriteBatch rc = null;
            if (this.shutdown) {
                throw new IOException("Async Writter Thread Shutdown");
            }
            if (this.firstAsyncException != null) {
                throw this.firstAsyncException;
            }
            if (!this.running) {
                this.running = true;
                this.thread = new Thread(){

                    public void run() {
                        DataFileAppender.this.processQueue();
                    }
                };
                this.thread.setPriority(10);
                this.thread.setDaemon(true);
                this.thread.setName("ActiveMQ Data File Writer");
                this.thread.start();
            }
            if (this.nextWriteBatch == null) {
                rc = this.nextWriteBatch = new WriteBatch(dataFile, write);
                this.enqueueMutex.notify();
            } else if (this.nextWriteBatch.canAppend(dataFile, write)) {
                this.nextWriteBatch.append(write);
                rc = this.nextWriteBatch;
            } else {
                try {
                    while (this.nextWriteBatch != null) {
                        this.enqueueMutex.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                if (this.shutdown) {
                    throw new IOException("Async Writter Thread Shutdown");
                }
                rc = this.nextWriteBatch = new WriteBatch(dataFile, write);
                this.enqueueMutex.notify();
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                if (this.running) {
                    this.enqueueMutex.notifyAll();
                } else {
                    this.shutdownDone.countDown();
                }
            }
        }
        try {
            this.shutdownDone.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueue() {
        DataFile dataFile = null;
        RandomAccessFile file = null;
        try {
            DataByteArrayOutputStream buff = new DataByteArrayOutputStream(this.maxWriteBatchSize);
            block23: while (true) {
                WriteCommand write;
                Object o = null;
                Object object = this.enqueueMutex;
                synchronized (object) {
                    while (true) {
                        if (this.shutdown) {
                            o = SHUTDOWN_COMMAND;
                            break;
                        }
                        if (this.nextWriteBatch != null) {
                            o = this.nextWriteBatch;
                            this.nextWriteBatch = null;
                            break;
                        }
                        this.enqueueMutex.wait();
                    }
                    this.enqueueMutex.notify();
                }
                if (o == SHUTDOWN_COMMAND) break;
                WriteBatch wb = (WriteBatch)o;
                if (dataFile != wb.dataFile) {
                    if (file != null) {
                        dataFile.closeRandomAccessFile(file);
                    }
                    dataFile = wb.dataFile;
                    file = dataFile.openRandomAccessFile(true);
                }
                file.seek(write.location.getOffset());
                if (wb.size == write.location.getSize()) {
                    file.writeInt(write.location.getSize());
                    file.writeByte(write.location.getType());
                    file.write(RESERVED_SPACE);
                    file.write(AsyncDataManager.ITEM_HEAD_SOR);
                    file.write(write.data.getData(), write.data.getOffset(), write.data.getLength());
                    file.write(AsyncDataManager.ITEM_HEAD_EOR);
                } else {
                    for (write = wb.first; write != null; write = (WriteCommand)write.getNext()) {
                        buff.writeInt(write.location.getSize());
                        buff.writeByte(write.location.getType());
                        buff.write(RESERVED_SPACE);
                        buff.write(AsyncDataManager.ITEM_HEAD_SOR);
                        buff.write(write.data.getData(), write.data.getOffset(), write.data.getLength());
                        buff.write(AsyncDataManager.ITEM_HEAD_EOR);
                    }
                    ByteSequence sequence = buff.toByteSequence();
                    file.write(sequence.getData(), sequence.getOffset(), sequence.getLength());
                    buff.reset();
                }
                file.getFD().sync();
                WriteCommand lastWrite = (WriteCommand)wb.first.getTailNode();
                this.dataManager.setLastAppendLocation(lastWrite.location);
                wb.latch.countDown();
                write = wb.first;
                while (true) {
                    if (write == null) continue block23;
                    if (!write.sync) {
                        this.inflightWrites.remove(new WriteKey(write.location));
                    }
                    if (write.onComplete != null) {
                        try {
                            write.onComplete.run();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    write = (WriteCommand)write.getNext();
                }
                break;
            }
            buff.close();
        }
        catch (IOException e) {
            Object object = this.enqueueMutex;
            synchronized (object) {
                this.firstAsyncException = e;
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            try {
                if (file != null) {
                    dataFile.closeRandomAccessFile(file);
                }
            }
            catch (Throwable ignore) {}
            this.shutdownDone.countDown();
        }
    }

    public static class WriteCommand
    extends LinkedNode {
        public final Location location;
        public final ByteSequence data;
        final boolean sync;
        public final Runnable onComplete;

        public WriteCommand(Location location, ByteSequence data, boolean sync) {
            this.location = location;
            this.data = data;
            this.sync = sync;
            this.onComplete = null;
        }

        public WriteCommand(Location location, ByteSequence data, Runnable onComplete) {
            this.location = location;
            this.data = data;
            this.onComplete = onComplete;
            this.sync = false;
        }
    }

    public class WriteBatch {
        public final DataFile dataFile;
        public final WriteCommand first;
        public final CountDownLatch latch = new CountDownLatch(1);
        public int size;

        public WriteBatch(DataFile dataFile, WriteCommand write) throws IOException {
            this.dataFile = dataFile;
            this.first = write;
            this.size += write.location.getSize();
        }

        public boolean canAppend(DataFile dataFile, WriteCommand write) {
            if (dataFile != this.dataFile) {
                return false;
            }
            return this.size + write.location.getSize() < DataFileAppender.this.maxWriteBatchSize;
        }

        public void append(WriteCommand write) throws IOException {
            this.first.getTailNode().linkAfter(write);
            this.size += write.location.getSize();
        }
    }

    public static class WriteKey {
        private final int file;
        private final long offset;
        private final int hash;

        public WriteKey(Location item) {
            this.file = item.getDataFileId();
            this.offset = item.getOffset();
            this.hash = (int)((long)this.file ^ this.offset);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WriteKey) {
                WriteKey di = (WriteKey)obj;
                return di.file == this.file && di.offset == this.offset;
            }
            return false;
        }
    }
}

