/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.management.ObjectName;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.LogicExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.NoLocalExpression;
import org.apache.activemq.selector.SelectorParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractSubscription
implements Subscription {
    private static final Log LOG = LogFactory.getLog(AbstractSubscription.class);
    protected Broker broker;
    protected Destination destination;
    protected ConnectionContext context;
    protected ConsumerInfo info;
    protected final DestinationFilter destinationFilter;
    protected final CopyOnWriteArrayList<Destination> destinations = new CopyOnWriteArrayList();
    private BooleanExpression selectorExpression;
    private ObjectName objectName;

    public AbstractSubscription(Broker broker, Destination destination, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        this.broker = broker;
        this.destination = destination;
        this.context = context;
        this.info = info;
        this.destinationFilter = DestinationFilter.parseFilter(info.getDestination());
        this.selectorExpression = AbstractSubscription.parseSelector(info);
    }

    private static BooleanExpression parseSelector(ConsumerInfo info) throws InvalidSelectorException {
        BooleanExpression rc = null;
        if (info.getSelector() != null) {
            rc = new SelectorParser().parse(info.getSelector());
        }
        if (info.isNoLocal()) {
            rc = rc == null ? new NoLocalExpression(info.getConsumerId().getConnectionId()) : LogicExpression.createAND(new NoLocalExpression(info.getConsumerId().getConnectionId()), rc);
        }
        if (info.getAdditionalPredicate() != null) {
            rc = rc == null ? info.getAdditionalPredicate() : LogicExpression.createAND(info.getAdditionalPredicate(), rc);
        }
        return rc;
    }

    public boolean matches(MessageReference node, MessageEvaluationContext context) throws IOException {
        ConsumerId targetConsumerId = node.getTargetConsumerId();
        if (targetConsumerId != null && !targetConsumerId.equals(this.info.getConsumerId())) {
            return false;
        }
        try {
            return (this.selectorExpression == null || this.selectorExpression.matches(context)) && this.context.isAllowedToConsume(node);
        }
        catch (JMSException e) {
            LOG.info("Selector failed to evaluate: " + e.getMessage(), e);
            return false;
        }
    }

    public boolean matches(ActiveMQDestination destination) {
        return this.destinationFilter.matches(destination);
    }

    public void add(ConnectionContext context, Destination destination) throws Exception {
        this.destinations.add(destination);
    }

    public void remove(ConnectionContext context, Destination destination) throws Exception {
        this.destinations.remove(destination);
    }

    public ConsumerInfo getConsumerInfo() {
        return this.info;
    }

    public void gc() {
    }

    public boolean isSlave() {
        return this.broker.getBrokerService().isSlave();
    }

    public ConnectionContext getContext() {
        return this.context;
    }

    public ConsumerInfo getInfo() {
        return this.info;
    }

    public BooleanExpression getSelectorExpression() {
        return this.selectorExpression;
    }

    public String getSelector() {
        return this.info.getSelector();
    }

    public void setSelector(String selector) throws InvalidSelectorException {
        ConsumerInfo copy = this.info.copy();
        copy.setSelector(selector);
        BooleanExpression newSelector = AbstractSubscription.parseSelector(copy);
        this.info.setSelector(selector);
        this.selectorExpression = newSelector;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public int getPrefetchSize() {
        return this.info.getPrefetchSize();
    }

    public boolean isRecoveryRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRecoveredMessage(ConnectionContext context, MessageReference message) throws Exception {
        boolean result = false;
        MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
        try {
            msgContext.setDestination(message.getRegionDestination().getActiveMQDestination());
            msgContext.setMessageReference(message);
            result = this.matches(message, msgContext);
            if (result) {
                this.doAddRecoveredMessage(message);
            }
        }
        finally {
            msgContext.clear();
        }
        return result;
    }

    public ActiveMQDestination getActiveMQDestination() {
        return this.info != null ? this.info.getDestination() : null;
    }

    public boolean isBrowser() {
        return this.info != null && this.info.isBrowser();
    }

    public int getInFlightUsage() {
        if (this.info.getPrefetchSize() > 0) {
            return this.getInFlightSize() * 100 / this.info.getPrefetchSize();
        }
        return Integer.MAX_VALUE;
    }

    protected void doAddRecoveredMessage(MessageReference message) throws Exception {
        this.add(message);
    }
}

