/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.proto.repository.dummy;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.proto.repository.Experiment;
import fi.csc.microarray.proto.repository.Query;
import fi.csc.microarray.proto.repository.RepositoryBase;
import fi.csc.microarray.proto.repository.dummy.DummyExperiment;
import fi.csc.microarray.proto.repository.schema.ParameterClass;
import fi.csc.microarray.proto.repository.schema.ParameterInstance;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyRepository
extends RepositoryBase {
    private ParameterClass rootClass;
    private int classHierarchyDepth;

    @Override
    public String getType() {
        return "Dummy repository";
    }

    @Override
    public String getIdentifier() {
        return "";
    }

    @Override
    public ParameterClass getRootClass() throws MicroarrayException {
        if (this.rootClass == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                InputStream is = DummyRepository.class.getResourceAsStream("/MOSubClasses.xml");
                Document document = builder.parse(is);
                Node rootNode = document.getElementsByTagName("Classes").item(0);
                if (!(rootNode instanceof Element)) {
                    throw new IllegalArgumentException("rootNode is " + rootNode.getClass().getSimpleName() + ", value " + rootNode.toString());
                }
                this.rootClass = DummyRepository.createNamedParameterClassFromElement("Root", (Element)rootNode);
                this.classHierarchyDepth = this.rootClass.setGrade(0) + 1;
            }
            catch (ParserConfigurationException e) {
                throw new MicroarrayException(e);
            }
            catch (SAXException e) {
                throw new MicroarrayException(e);
            }
            catch (IOException e) {
                throw new MicroarrayException(e);
            }
        }
        return this.rootClass;
    }

    @Override
    public int getClassHierarchyDepth() {
        return this.classHierarchyDepth;
    }

    @Override
    public Iterable<Experiment> executeSubQuery(Query query) {
        DummyExperiment exp = new DummyExperiment();
        LinkedList<Experiment> exps = new LinkedList<Experiment>();
        exps.add(exp);
        return exps;
    }

    @Override
    public String toString() {
        return this.getType();
    }

    protected static ParameterClass createParameterClassFromElement(Element classElement) {
        String name = classElement.getAttributeNS(null, "name");
        return DummyRepository.createNamedParameterClassFromElement(name, classElement);
    }

    protected static ParameterClass createNamedParameterClassFromElement(String name, Element classElement) {
        ParameterClass paramClass = new ParameterClass(name);
        NodeList childNodeList = classElement.getChildNodes();
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            int j;
            Node childNode = childNodeList.item(i);
            if (!(childNode instanceof Element)) continue;
            Element childElement = (Element)childNode;
            String tag = childElement.getTagName();
            if (tag.equals("Description")) {
                NodeList descriptionChildList = childElement.getChildNodes();
                for (j = 0; j < descriptionChildList.getLength(); ++j) {
                    Node descriptionChild = descriptionChildList.item(j);
                    if (!(descriptionChild instanceof Text)) continue;
                    Text descriptionText = (Text)descriptionChild;
                    String description = DummyRepository.parseTextElement(descriptionText);
                    paramClass.setDescription(description);
                }
                continue;
            }
            if (tag.equals("Class")) {
                ParameterClass paramSubClass = DummyRepository.createParameterClassFromElement(childElement);
                if (paramSubClass == null) continue;
                paramClass.addSubclass(paramSubClass);
                continue;
            }
            if (!tag.equals("Instances")) continue;
            NodeList instanceList = childElement.getElementsByTagName("Instance");
            for (j = 0; j < instanceList.getLength(); ++j) {
                Element instanceElement = (Element)instanceList.item(j);
                ParameterInstance paramInstance = DummyRepository.createParameterInstanceFromElement(instanceElement);
                paramClass.addInstance(paramInstance);
            }
        }
        return paramClass;
    }

    protected static ParameterInstance createParameterInstanceFromElement(Element instanceElement) {
        String name = instanceElement.getAttributeNS(null, "name");
        ParameterInstance paramInstance = new ParameterInstance(name);
        NodeList synonymList = instanceElement.getElementsByTagName("Synonym");
        for (int i = 0; i < synonymList.getLength(); ++i) {
            Element synonymElement = (Element)synonymList.item(i);
            String synonymName = synonymElement.getAttributeNS(null, "name");
            paramInstance.addSynonym(synonymName);
        }
        return paramInstance;
    }

    protected static String parseTextElement(Text textElement) {
        String text = textElement.toString();
        if ((text = text.substring(8, text.length() - 1)).indexOf(10) != -1) {
            text = text.replace('\n', ' ');
        }
        while (text.indexOf("  ") != -1) {
            text = text.replace("  ", " ");
        }
        return text;
    }
}

