/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.frontend;

import fi.csc.microarray.MicroarrayConfiguration;
import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class WebstartJettyServer {
    private static final int PORT_NUMBER = 8081;
    private static Logger logger;
    private Server jettyInstance;

    public static void main(String[] args) throws Exception {
        System.setProperty("DEBUG", "true");
        WebstartJettyServer server = new WebstartJettyServer();
        server.start();
        server.jettyInstance.join();
    }

    public void start() throws Exception {
        if (logger.isDebugEnabled()) {
            System.setProperty("DEBUG", "true");
        }
        this.jettyInstance = new Server();
        this.jettyInstance.setThreadPool((ThreadPool)new QueuedThreadPool());
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setServer(this.jettyInstance);
        connector.setPort(8081);
        this.jettyInstance.setConnectors(new Connector[]{connector});
        Context wsRoot = new Context((HandlerContainer)this.jettyInstance, "/", false, false);
        wsRoot.setResourceBase("web-content/");
        wsRoot.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        this.jettyInstance.start();
    }

    public boolean isRunning() {
        return this.jettyInstance.isRunning();
    }

    static {
        try {
            MicroarrayConfiguration.loadConfiguration();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger = Logger.getLogger(WebstartJettyServer.class);
    }
}

