/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.proto.MyPlot;
import fi.csc.microarray.util.FloatArrayList;
import javax.swing.JComponent;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.ColorPalette;
import org.jfree.chart.plot.GreyPalette;
import org.jfree.chart.plot.Plot;
import org.jfree.data.contour.ContourDataset;
import org.jfree.data.contour.DefaultContourDataset;

public class ArrayLayout
extends Visualisation {
    public ArrayLayout(VisualisationFrame frame) {
        super(frame);
    }

    public JComponent getVisualisation(DataBean dataBean) throws Exception {
        FloatArrayList transformedIntensities = new FloatArrayList();
        for (float intensity : dataBean.queryFeatures("log(/normalised-expression)").asFloats()) {
            if ((double)intensity <= 0.0) {
                intensity = Float.MIN_VALUE;
            }
            transformedIntensities.add(intensity);
        }
        float max = transformedIntensities.max();
        for (int c = 0; c < transformedIntensities.size(); ++c) {
            transformedIntensities.set(c, Float.valueOf(transformedIntensities.get(c).floatValue() / max));
        }
        double[] xs = new double[transformedIntensities.size()];
        double[] ys = new double[transformedIntensities.size()];
        double[] zs = new double[transformedIntensities.size()];
        int i = 0;
        int[] dimensions = ArrayLayout.inferDimensions(transformedIntensities);
        for (int x = 0; x < dimensions[0]; ++x) {
            for (int y = 0; y < dimensions[1]; ++y) {
                xs[i] = x;
                ys[i] = y;
                zs[i] = transformedIntensities.getFloat((dimensions[1] - y - 1) * dimensions[0] + x);
                ++i;
            }
        }
        DefaultContourDataset data = new DefaultContourDataset((Comparable)((Object)"data"), DefaultContourDataset.formObjectArray((double[])xs), DefaultContourDataset.formObjectArray((double[])ys), DefaultContourDataset.formObjectArray((double[])zs));
        ColorBar colors = new ColorBar("Expression");
        colors.setColorPalette((ColorPalette)new GreyPalette());
        colors.autoAdjustRange();
        NumberAxis xAxis = new NumberAxis("x");
        NumberAxis yAxis = new NumberAxis("y");
        MyPlot plot = new MyPlot((ContourDataset)data, (ValueAxis)xAxis, (ValueAxis)yAxis, colors);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.setTitle(dataBean.getName());
        return this.makePanel(chart);
    }

    public static int[] inferDimensions(FloatArrayList intensities) throws MicroarrayException {
        int i = (int)Math.sqrt(intensities.size());
        while (intensities.size() % i != 0) {
            --i;
        }
        return new int[]{i, intensities.size() / i};
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.isApplicableTo(bean);
        return isTabular && bean.queryFeatures("/column/MEAN").exists();
    }
}

