/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import java.util.HashMap;

public class TableAnnotationProvider {
    private static final String TABLE_COLUMN_QUERY = "/column/";
    private static final String COLUMN_ALL = "*";
    private static final String COLUMN_DESCRIPTION = "description";
    private static final String COLUMN_SYMBOL = "symbol";
    private HashMap<String, String> annotatedIdentifiers = new HashMap();
    private HashMap<String, String> descriptions = new HashMap();
    private DataBean data;

    public TableAnnotationProvider(DataBean bean) throws MicroarrayException {
        this(bean.queryFeatures("/column/*").asTable());
    }

    public TableAnnotationProvider(Table table) throws MicroarrayException {
        while (table.nextRow()) {
            String identifier = table.getStringValue(" ");
            String symbol = table.getStringValue(COLUMN_SYMBOL);
            String actualDescription = table.getStringValue(COLUMN_DESCRIPTION);
            String annotatedIdentifier = symbol != null ? symbol + " (" + identifier + ")" : identifier;
            String description = actualDescription != null ? actualDescription : annotatedIdentifier;
            this.annotatedIdentifiers.put(identifier, annotatedIdentifier);
            this.descriptions.put(identifier, description);
        }
    }

    public String getAnnotatedRowname(String rowIdentifier) {
        return this.annotatedIdentifiers.get(rowIdentifier);
    }

    public String getRowDescription(String rowIdentifier) {
        return this.descriptions.get(rowIdentifier);
    }

    public boolean isForData(DataBean data) {
        return this.data != null ? this.data.equals(data) : false;
    }
}

