/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.tasks;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.tasks.TaskEventListener;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.databeans.DataBean;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Task {
    private static final Logger logger = Logger.getLogger(Task.class);
    private Map<String, DataBean> inputs = new HashMap<String, DataBean>();
    private List<Object> parameters = new LinkedList<Object>();
    private State state = State.NEW;
    private String stateDetail = "";
    private String name;
    private long startTime;
    private long endTime;
    private String errorMessage;
    private String screenOutput;
    private Map<String, DataBean> outputs = new HashMap<String, DataBean>();
    private String id;
    private boolean hasBeenRetried = false;
    private boolean hidden = false;
    private List<TaskEventListener> listeners = new LinkedList<TaskEventListener>();

    public Task(String name) {
        this.name = name;
        this.id = this.generateId();
    }

    public Task(String name, boolean hidden) {
        this(name);
        this.hidden = hidden;
    }

    public String getName() {
        return this.name;
    }

    public String getNamePrettyPrinted() {
        return this.name.replaceAll("\"", "").replaceAll("/", " / ");
    }

    public synchronized void setState(State newState) {
        State oldState = this.state;
        this.state = newState;
        this.stateDetail = "";
        TaskStateChangeNotifier changeNotifier = new TaskStateChangeNotifier(oldState, newState);
        SwingUtilities.invokeLater(changeNotifier);
    }

    public synchronized State getState() {
        return this.state;
    }

    public void addParameter(String name, Object input) {
        if (input instanceof Float) {
            this.addParameter(name, (Float)input);
        } else if (input instanceof Integer) {
            this.addParameter(name, (Integer)input);
        } else if (input instanceof String) {
            this.addParameter(name, (String)input);
        } else {
            throw new IllegalArgumentException("unsupported input type: " + input.getClass().getSimpleName());
        }
    }

    public void addParameter(String name, Integer input) {
        this.addParameter(name, input.toString());
    }

    public void addParameter(String name, Float input) {
        this.addParameter(name, input.toString());
    }

    public void addParameter(String name, String input) {
        logger.debug((Object)("added parameter " + name + " -> " + input));
        this.parameters.add(input);
    }

    public DataBean getInput(String name) {
        return this.inputs.get(name);
    }

    public List<String> getParameters() throws TaskException, MicroarrayException {
        LinkedList<String> inputArray = new LinkedList<String>();
        for (Object input : this.parameters) {
            if (input instanceof String) {
                inputArray.add((String)input);
                continue;
            }
            throw new TaskException("do not know how to encode" + input.getClass().getName());
        }
        return inputArray;
    }

    public void addOutput(String name, DataBean output) throws IOException, MicroarrayException {
        this.outputs.put(name, output);
    }

    public DataBean getOutput(String name) {
        return this.outputs.get(name);
    }

    public void addInput(String name, DataBean input) {
        this.inputs.put(name, input);
    }

    public Iterable<String> inputNames() {
        return this.inputs.keySet();
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Iterable<String> outputNames() {
        return this.outputs.keySet();
    }

    public Iterable<DataBean> outputs() {
        return this.outputs.values();
    }

    public String getScreenOutput() {
        return this.screenOutput;
    }

    public void setScreenOutput(String screenOutput) {
        this.screenOutput = screenOutput;
    }

    public String getStateDetail() {
        if (this.stateDetail != null) {
            return this.stateDetail;
        }
        return "";
    }

    public void setStateDetail(String stateDetail) {
        this.stateDetail = stateDetail;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void changeId() {
        this.id = this.generateId();
    }

    public boolean hasBeenRetried() {
        return this.hasBeenRetried;
    }

    public void setHasBeenRetried(boolean hasBeenRetried) {
        this.hasBeenRetried = hasBeenRetried;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getExecutionTime() {
        if (this.endTime > this.startTime) {
            return this.endTime - this.startTime;
        }
        if (this.startTime > 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return 0L;
    }

    private String generateId() {
        return UUID.randomUUID().toString();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void addTaskEventListener(TaskEventListener listener) {
        this.listeners.add(listener);
    }

    private class TaskStateChangeNotifier
    implements Runnable {
        private State oldState;
        private State newState;

        public TaskStateChangeNotifier(State oldState, State newState) {
            this.oldState = oldState;
            this.newState = newState;
        }

        public void run() {
            for (TaskEventListener listener : Task.this.listeners) {
                listener.onStateChange(Task.this, this.oldState, this.newState);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NEW("New"),
        TRANSFERRING_INPUTS("Transferring inputs"),
        WAITING("Waiting"),
        RUNNING("Running"),
        TRANSFERRING_OUTPUTS("Transferring outputs"),
        COMPLETED("Completed"),
        FAILED("Failed"),
        FAILED_USER_ERROR("Failed, user error"),
        ERROR("Error"),
        CANCELLED("Cancelled"),
        TIMEOUT("Timeout");

        private String description;

        private State(String description) {
            this.description = description;
        }

        public boolean isFinished() {
            return this.equals((Object)COMPLETED) || this.equals((Object)FAILED) || this.equals((Object)FAILED_USER_ERROR) || this.equals((Object)ERROR) || this.equals((Object)CANCELLED) || this.equals((Object)TIMEOUT);
        }

        public boolean finishedSuccesfully() {
            return this.equals((Object)COMPLETED);
        }

        public String toString() {
            return this.description;
        }
    }
}

