/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport.trimmer;

import fi.csc.microarray.client.dataimport.trimmer.DataTrimmingOperation;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTrimmer {
    private Stack<DataTrimmingOperation> operations = new Stack();
    private Vector<Integer> ignoreColumns = new Vector();

    public void pushOperation(DataTrimmingOperation operation) {
        this.operations.push(operation);
    }

    public void pushOperations(List<DataTrimmingOperation> operationList) {
        this.operations.addAll(operationList);
    }

    public void popOperation() {
        this.operations.pop();
    }

    public int getOperationCount() {
        return this.operations.size();
    }

    public void clear() {
        this.operations.clear();
    }

    public void addIgnoreColumnNumber(int columnIndex) {
        this.ignoreColumns.add(columnIndex);
    }

    public String doTrimming(String stringToTrim, int column) {
        String stringToReturn = stringToTrim;
        for (DataTrimmingOperation operation : this.operations) {
            if (this.ignoreColumns.contains(column) || column != operation.getColumnIndex() && operation.getColumnIndex() != Integer.MAX_VALUE) continue;
            stringToReturn = operation.doTrimming(stringToReturn);
        }
        return stringToReturn;
    }
}

