/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport.table;

import fi.csc.microarray.client.dataimport.ImportScreen;
import fi.csc.microarray.client.dataimport.ProgressInformator;
import fi.csc.microarray.client.dataimport.RunnableImportProcess;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class InformationDialog
extends JFrame
implements ActionListener,
ProgressInformator {
    private static final Logger logger = Logger.getLogger(InformationDialog.class);
    private final Dimension BUTTON_SIZE = new Dimension(80, 25);
    private final Dimension PROGRESSBAR_SIZE = new Dimension(300, 18);
    private RunnableImportProcess process;
    private JPanel contentPane;
    private JLabel label;
    private JButton cancelButton;
    private JProgressBar progressBar;
    private ImportScreen owner;

    public InformationDialog(String title, String message, ImportScreen owner) {
        super(title);
        this.label = new JLabel(message);
        this.label.setPreferredSize(this.PROGRESSBAR_SIZE);
        this.owner = owner;
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(this.BUTTON_SIZE);
        this.cancelButton.addActionListener(this);
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(this.PROGRESSBAR_SIZE);
        this.contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets.set(8, 12, 10, 4);
        c.gridx = 0;
        c.gridy = 0;
        this.contentPane.add((Component)this.label, c);
        c.insets.set(0, 12, 8, 12);
        c.gridy = 1;
        this.contentPane.add((Component)this.progressBar, c);
        c.insets.set(4, 2, 12, 8);
        c.anchor = 13;
        c.gridy = 2;
        this.contentPane.add((Component)this.cancelButton, c);
        logger.debug((Object)("Components on the dialog: " + this.contentPane.getComponentCount()));
        this.add(this.contentPane);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.stopProcess();
        }
    }

    public void setValue(int value) {
        class ValueChanger
        implements Runnable {
            private int value;

            public ValueChanger(int value) {
                this.value = value;
            }

            public void run() {
                InformationDialog.this.progressBar.setValue(this.value);
            }
        }
        SwingUtilities.invokeLater(new ValueChanger(value));
    }

    public void setMessage(String message) {
        class MessageChanger
        implements Runnable {
            private String message;

            public MessageChanger(String message) {
                this.message = message;
            }

            public void run() {
                InformationDialog.this.label.setText(this.message);
            }
        }
        SwingUtilities.invokeLater(new MessageChanger(message));
    }

    public void setMaximumValue(int max) {
        class MaximumChanger
        implements Runnable {
            private int max;

            public MaximumChanger(int max) {
                this.max = max;
            }

            public void run() {
                InformationDialog.this.progressBar.setMaximum(this.max);
            }
        }
        SwingUtilities.invokeLater(new MaximumChanger(max));
    }

    public void setMinimunValue(int min) {
        class MinimumChanger
        implements Runnable {
            private int min;

            public MinimumChanger(int min) {
                this.min = min;
            }

            public void run() {
                InformationDialog.this.progressBar.setMaximum(this.min);
            }
        }
        SwingUtilities.invokeLater(new MinimumChanger(min));
    }

    public void destroyInformator() {
        if (this.owner != null) {
            this.owner.getFrame().setEnabled(true);
        }
        this.setVisible(false);
        try {
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializeInformator() {
        if (this.owner != null) {
            this.owner.getFrame().setEnabled(false);
        }
        this.setVisible(true);
    }

    public void stopProcess() {
        if (this.process == null) {
            throw new IllegalStateException("No process set to this informator");
        }
        this.process.stopProcess();
    }

    public void setProcess(RunnableImportProcess process) {
        this.process = process;
    }

    public void setIndeterminate(boolean newValue) {
        this.progressBar.setIndeterminate(newValue);
    }
}

