/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.model.FromType;
import org.apache.camel.model.MulticastType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RouteType;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.GraphGeneratorSupport;
import org.apache.camel.view.NodeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlGraphGenerator
extends GraphGeneratorSupport {
    private boolean addUrl = true;

    public XmlGraphGenerator(String dir) {
        super(dir, ".xml");
    }

    @Override
    protected void generateFile(PrintWriter writer, Map<String, List<RouteType>> map) {
        writer.println("<?xml version='1.0' encoding='UTF-8'?>");
        writer.println("<Graph>");
        writer.println();
        if (map.size() > 0) {
            writer.println("<Node id='root' name='Camel Routes' description='Collection of Camel Routes' nodeType='root'/>");
        }
        this.printRoutes(writer, map);
        writer.println();
        writer.println("</Graph>");
    }

    protected void printRoutes(PrintWriter writer, Map<String, List<RouteType>> map) {
        Set<Map.Entry<String, List<RouteType>>> entries = map.entrySet();
        for (Map.Entry<String, List<RouteType>> entry : entries) {
            String group = entry.getKey();
            this.printRoutes(writer, group, entry.getValue());
        }
    }

    protected void printRoutes(PrintWriter writer, String group, List<RouteType> routes) {
        if ((group = this.encode(group)) != null) {
            int idx = group.lastIndexOf(46);
            String name = group;
            if (idx > 0 && idx < group.length() - 1) {
                name = group.substring(idx + 1);
            }
            writer.println("<Node id='" + group + "' name='" + name + "' description='" + group + "' nodeType='group'/>");
            writer.println("<Edge fromID='root' toID='" + group + "'/>");
        }
        for (RouteType route : routes) {
            List<FromType> inputs = route.getInputs();
            boolean first = true;
            for (FromType input : inputs) {
                NodeData nodeData = this.getNodeData(input);
                if (first) {
                    first = false;
                    if (group != null) {
                        writer.println("<Edge fromID='" + group + "' toID='" + this.encode(nodeData.id) + "'/>");
                    }
                }
                this.printRoute(writer, route, nodeData);
            }
            writer.println();
        }
    }

    protected void printRoute(PrintWriter writer, RouteType route, NodeData nodeData) {
        this.printNode(writer, nodeData);
        NodeData from = nodeData;
        for (ProcessorType<?> output : route.getOutputs()) {
            NodeData newData;
            from = newData = this.printNode(writer, from, output);
        }
    }

    protected NodeData printNode(PrintWriter writer, NodeData fromData, ProcessorType node) {
        List<ProcessorType> outputs;
        if (node instanceof MulticastType) {
            List<ProcessorType<?>> outputs2 = node.getOutputs();
            for (ProcessorType<?> output : outputs2) {
                this.printNode(writer, fromData, output);
            }
            return fromData;
        }
        NodeData toData = this.getNodeData(node);
        this.printNode(writer, toData);
        if (fromData != null) {
            writer.print("<Edge fromID=\"");
            writer.print(this.encode(fromData.id));
            writer.print("\" toID=\"");
            writer.print(this.encode(toData.id));
            String association = toData.edgeLabel;
            if (ObjectHelper.isNullOrBlank(association)) {
                writer.print("\" association=\"");
                writer.print(this.encode(association));
            }
            writer.println("\"/>");
        }
        if ((outputs = toData.outputs) != null) {
            for (ProcessorType output : outputs) {
                NodeData newData = this.printNode(writer, toData, output);
                if (this.isMulticastNode(node)) continue;
                toData = newData;
            }
        }
        return toData;
    }

    protected void printNode(PrintWriter writer, NodeData data) {
        if (!data.nodeWritten) {
            data.nodeWritten = true;
            writer.println();
            writer.print("<Node id=\"");
            writer.print(this.encode(data.id));
            writer.print("\" name=\"");
            String name = data.label;
            if (ObjectHelper.isNullOrBlank(name)) {
                name = data.tooltop;
            }
            writer.print(this.encode(name));
            writer.print("\" nodeType=\"");
            String nodeType = data.image;
            if (ObjectHelper.isNullOrBlank(nodeType) && ObjectHelper.isNullOrBlank(nodeType = data.shape)) {
                nodeType = "node";
            }
            writer.print(this.encode(nodeType));
            writer.print("\" description=\"");
            writer.print(this.encode(data.tooltop));
            if (this.addUrl) {
                writer.print("\" url=\"");
                writer.print(this.encode(data.url));
            }
            writer.println("\"/>");
        }
    }

    protected String encode(String text) {
        if (text == null) {
            return "";
        }
        return text.replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;");
    }
}

