/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UnsafeUriCharactersEncoder {
    static BitSet unsafeCharacters;
    private static final transient Log LOG;
    private static final char[] HEX_DIGITS;

    private UnsafeUriCharactersEncoder() {
    }

    public static String encode(String s) {
        int n = s.length();
        if (n == 0) {
            return s;
        }
        try {
            byte[] bytes = s.getBytes("UTF8");
            int i = 0;
            while (!unsafeCharacters.get(bytes[i])) {
                if (++i < bytes.length) continue;
                return s;
            }
            StringBuffer sb = new StringBuffer();
            for (byte b : bytes) {
                if (unsafeCharacters.get(b)) {
                    UnsafeUriCharactersEncoder.appendEscape(sb, b);
                    continue;
                }
                sb.append((char)b);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"Can't encoding the uri: ", (Throwable)e);
            return null;
        }
    }

    private static void appendEscape(StringBuffer sb, byte b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4 & 0xF]);
        sb.append(HEX_DIGITS[b >> 0 & 0xF]);
    }

    static {
        LOG = LogFactory.getLog(UnsafeUriCharactersEncoder.class);
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        unsafeCharacters = new BitSet(256);
        unsafeCharacters.set(32);
        unsafeCharacters.set(34);
        unsafeCharacters.set(60);
        unsafeCharacters.set(62);
        unsafeCharacters.set(35);
        unsafeCharacters.set(37);
        unsafeCharacters.set(123);
        unsafeCharacters.set(125);
        unsafeCharacters.set(124);
        unsafeCharacters.set(92);
        unsafeCharacters.set(94);
        unsafeCharacters.set(126);
        unsafeCharacters.set(91);
        unsafeCharacters.set(93);
        unsafeCharacters.set(96);
    }
}

