/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.processor.idempotent.MessageIdRepository;
import org.apache.camel.util.LRUCache;

public class MemoryMessageIdRepository
implements MessageIdRepository {
    private Map cache;

    public MemoryMessageIdRepository(Map set) {
        this.cache = set;
    }

    public static MessageIdRepository memoryMessageIdRepository() {
        return MemoryMessageIdRepository.memoryMessageIdRepository(new HashMap());
    }

    public static MessageIdRepository memoryMessageIdRepository(int cacheSize) {
        return MemoryMessageIdRepository.memoryMessageIdRepository(new LRUCache(cacheSize));
    }

    public static MessageIdRepository memoryMessageIdRepository(Map cache) {
        return new MemoryMessageIdRepository(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String messageId) {
        Map map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(messageId)) {
                return true;
            }
            this.cache.put(messageId, messageId);
            return false;
        }
    }
}

