/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.camel.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayTypeConverter
implements TypeConverter {
    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        if (type.isArray()) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Object array = Array.newInstance(type.getComponentType(), collection.size());
                if (array instanceof Object[]) {
                    collection.toArray((Object[])array);
                } else {
                    int index = 0;
                    for (Object element : collection) {
                        Array.set(array, index++, element);
                    }
                }
                return (T)array;
            }
            if (value != null && value.getClass().isArray()) {
                int size = Array.getLength(value);
                Object answer = Array.newInstance(type.getComponentType(), size);
                for (int i = 0; i < size; ++i) {
                    Array.set(answer, i, Array.get(value, i));
                }
                return (T)answer;
            }
        } else if (Collection.class.isAssignableFrom(type) && value != null) {
            if (value instanceof Object[]) {
                return (T)Arrays.asList((Object[])value);
            }
            if (value.getClass().isArray()) {
                int size = Array.getLength(value);
                ArrayList<Object> answer = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    answer.add(Array.get(value, i));
                }
                return (T)answer;
            }
        }
        return null;
    }
}

