/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.UuidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageSupport
implements Message {
    private static final UuidGenerator DEFALT_ID_GENERATOR = new UuidGenerator();
    private Exchange exchange;
    private Object body;
    private String messageId = DEFALT_ID_GENERATOR.generateId();

    @Override
    public Object getBody() {
        if (this.body == null) {
            this.body = this.createBody();
        }
        return this.body;
    }

    @Override
    public <T> T getBody(Class<T> type) {
        Exchange e = this.getExchange();
        if (e != null) {
            TypeConverter converter = e.getContext().getTypeConverter();
            T answer = converter.convertTo(type, this.getBody());
            if (answer == null) {
                answer = converter.convertTo(type, this);
            }
            return answer;
        }
        return (T)this.getBody();
    }

    @Override
    public void setBody(Object body) {
        this.body = body;
    }

    @Override
    public <T> void setBody(Object value, Class<T> type) {
        T v;
        Exchange e = this.getExchange();
        if (e != null && (v = e.getContext().getTypeConverter().convertTo(type, value)) != null) {
            value = v;
        }
        this.setBody(value);
    }

    @Override
    public Message copy() {
        Message answer = this.newInstance();
        answer.copyFrom(this);
        return answer;
    }

    @Override
    public void copyFrom(Message that) {
        this.setMessageId(that.getMessageId());
        this.setBody(that.getBody());
        this.getHeaders().putAll(that.getHeaders());
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public abstract Message newInstance();

    protected Object createBody() {
        return null;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }
}

