/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.list;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.processor.loadbalancer.LoadBalancerConsumer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.spi.BrowsableEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListEndpoint
extends DefaultEndpoint<Exchange>
implements BrowsableEndpoint<Exchange> {
    private List<Exchange> exchanges;
    private TopicLoadBalancer loadBalancer = new TopicLoadBalancer();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ListEndpoint(String uri, CamelContext camelContext) {
        super(uri, camelContext);
        this.reset();
    }

    public ListEndpoint(String uri, Component component) {
        super(uri, component);
        this.reset();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public List<Exchange> getExchanges() {
        return this.exchanges;
    }

    public TopicLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public Producer<Exchange> createProducer() throws Exception {
        return new DefaultProducer<Exchange>((Endpoint)this){

            @Override
            public void process(Exchange exchange) throws Exception {
                ListEndpoint.this.onExchange(exchange);
            }
        };
    }

    @Override
    public Consumer<Exchange> createConsumer(Processor processor) throws Exception {
        return new LoadBalancerConsumer(this, processor, this.loadBalancer);
    }

    public void reset() {
        this.exchanges = this.createExchangeList();
    }

    protected List<Exchange> createExchangeList() {
        return new CopyOnWriteArrayList<Exchange>();
    }

    protected void onExchange(Exchange exchange) throws Exception {
        this.exchanges.add(exchange);
        this.loadBalancer.process(exchange);
    }
}

