/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Date;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.TestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsSendReceiveWithMessageExpirationTest
extends TestSupport {
    private static final Log LOG = LogFactory.getLog(JmsSendReceiveWithMessageExpirationTest.class);
    protected int messageCount = 100;
    protected String[] data;
    protected Session session;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected boolean durable;
    protected int deliveryMode = 2;
    protected long timeToLive = 5000L;
    protected boolean verbose;
    protected Connection connection;

    protected void setUp() throws Exception {
        super.setUp();
        this.data = new String[this.messageCount];
        for (int i = 0; i < this.messageCount; ++i) {
            this.data[i] = "Text for message: " + i + " at " + new Date();
        }
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.createConnection();
        if (this.durable) {
            this.connection.setClientID(((Object)((Object)this)).getClass().getName());
        }
        this.session = this.connection.createSession(false, 1);
    }

    public void testConsumeExpiredQueue() throws Exception {
        MessageProducer producer = this.createProducer(this.timeToLive);
        this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
        this.producerDestination = this.session.createQueue(this.getProducerSubject());
        MessageConsumer consumer = this.createConsumer();
        this.connection.start();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            message.setStringProperty("stringProperty", this.data[i]);
            message.setIntProperty("intProperty", i);
            if (this.verbose && LOG.isDebugEnabled()) {
                LOG.debug("About to send a queue message: " + message + " with text: " + this.data[i]);
            }
            producer.send(this.producerDestination, message);
        }
        Thread.sleep(this.timeToLive + 1000L);
        JmsSendReceiveWithMessageExpirationTest.assertNull((Object)consumer.receive(1000L));
    }

    public void testConsumeQueue() throws Exception {
        MessageProducer producer = this.createProducer(0L);
        this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
        this.producerDestination = this.session.createQueue(this.getProducerSubject());
        MessageConsumer consumer = this.createConsumer();
        this.connection.start();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            message.setStringProperty("stringProperty", this.data[i]);
            message.setIntProperty("intProperty", i);
            if (this.verbose && LOG.isDebugEnabled()) {
                LOG.debug("About to send a queue message: " + message + " with text: " + this.data[i]);
            }
            producer.send(this.producerDestination, message);
        }
        JmsSendReceiveWithMessageExpirationTest.assertNotNull((Object)consumer.receive(1000L));
    }

    public void testConsumeExpiredTopic() throws Exception {
        MessageProducer producer = this.createProducer(this.timeToLive);
        this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
        this.producerDestination = this.session.createTopic(this.getProducerSubject());
        MessageConsumer consumer = this.createConsumer();
        this.connection.start();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            message.setStringProperty("stringProperty", this.data[i]);
            message.setIntProperty("intProperty", i);
            if (this.verbose && LOG.isDebugEnabled()) {
                LOG.debug("About to send a topic message: " + message + " with text: " + this.data[i]);
            }
            producer.send(this.producerDestination, message);
        }
        Thread.sleep(this.timeToLive + 1000L);
        JmsSendReceiveWithMessageExpirationTest.assertNull((Object)consumer.receive(1000L));
    }

    public void testConsumeTopic() throws Exception {
        MessageProducer producer = this.createProducer(0L);
        this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
        this.producerDestination = this.session.createTopic(this.getProducerSubject());
        MessageConsumer consumer = this.createConsumer();
        this.connection.start();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            message.setStringProperty("stringProperty", this.data[i]);
            message.setIntProperty("intProperty", i);
            if (this.verbose && LOG.isDebugEnabled()) {
                LOG.debug("About to send a topic message: " + message + " with text: " + this.data[i]);
            }
            producer.send(this.producerDestination, message);
        }
        JmsSendReceiveWithMessageExpirationTest.assertNotNull((Object)consumer.receive(1000L));
    }

    protected MessageProducer createProducer(long timeToLive) throws JMSException {
        MessageProducer producer = this.session.createProducer(null);
        producer.setDeliveryMode(this.deliveryMode);
        producer.setTimeToLive(timeToLive);
        return producer;
    }

    protected MessageConsumer createConsumer() throws JMSException {
        if (this.durable) {
            LOG.info("Creating durable consumer");
            return this.session.createDurableSubscriber((Topic)this.consumerDestination, this.getName());
        }
        return this.session.createConsumer(this.consumerDestination);
    }

    protected void tearDown() throws Exception {
        LOG.info("Dumping stats...");
        LOG.info("Closing down connection");
        this.session.close();
        this.connection.close();
    }
}

