/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.misc.BitSet;
import org.antlr.misc.IntSet;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;

public class NFAToDFAConverter {
    protected List work = new LinkedList();
    protected NFAContext[] contextTrees;
    protected DFA dfa;
    public static boolean debug = false;
    public static boolean SINGLE_THREADED_NFA_CONVERSION = true;

    public NFAToDFAConverter(DFA dFA) {
        this.dfa = dFA;
        NFAState nFAState = dFA.getNFADecisionStartState();
        int n = dFA.nfa.grammar.getNumberOfAltsForDecisionNFA(nFAState);
        this.initContextTrees(n);
    }

    public void convert() {
        this.dfa.conversionStartTime = System.currentTimeMillis();
        this.dfa.startState = this.computeStartState();
        while (!(this.work.size() <= 0 || this.dfa.probe.analysisAborted() || this.dfa.probe.nonLLStarDecision || this.dfa.nfa.grammar.NFAToDFAConversionExternallyAborted())) {
            int n;
            DFAState dFAState = (DFAState)this.work.get(0);
            if (this.dfa.nfa.grammar.getWatchNFAConversion()) {
                System.out.println("convert DFA state " + dFAState.stateNumber + " (" + dFAState.getNFAConfigurations().size() + " nfa states)");
            }
            if ((n = this.dfa.getUserMaxLookahead()) > 0 && n == dFAState.getLookaheadDepth()) {
                this.resolveNonDeterminisms(dFAState);
                if (dFAState.isResolvedWithPredicates()) {
                    this.addPredicateTransitions(dFAState);
                } else {
                    dFAState.setAcceptState(true);
                }
            } else {
                this.findNewDFAStatesAndAddDFATransitions(dFAState);
            }
            this.work.remove(0);
        }
    }

    protected DFAState computeStartState() {
        NFAState nFAState = this.dfa.decisionNFAStartState;
        DFAState dFAState = this.dfa.newState();
        int n = 0;
        int n2 = 1;
        while (nFAState != null) {
            NFAContext nFAContext = this.contextTrees[n];
            if (n == 0 && this.dfa.getNFADecisionStartState().decisionStateType == 1) {
                int n3;
                n2 = n3 = this.dfa.nfa.grammar.getNumberOfAltsForDecisionNFA(this.dfa.decisionNFAStartState);
                this.closure((NFAState)nFAState.transition((int)0).target, n2, nFAContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, dFAState, true);
                n2 = 1;
            } else {
                this.closure((NFAState)nFAState.transition((int)0).target, n2, nFAContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, dFAState, true);
                ++n2;
            }
            ++n;
            if (nFAState.transition(1) == null) break;
            nFAState = (NFAState)nFAState.transition((int)1).target;
        }
        this.dfa.addState(dFAState);
        this.work.add(dFAState);
        return dFAState;
    }

    protected void findNewDFAStatesAndAddDFATransitions(DFAState dFAState) {
        int n;
        OrderedHashSet orderedHashSet = dFAState.getReachableLabels();
        Label label = new Label(-2);
        boolean bl = orderedHashSet.contains(label);
        if (!this.dfa.isGreedy() && bl) {
            this.convertToEOTAcceptState(dFAState);
            return;
        }
        int n2 = 0;
        HashMap hashMap = new HashMap();
        for (n = 0; !dFAState.abortedDueToMultipleRecursiveAlts && n < orderedHashSet.size(); ++n) {
            Label label2 = (Label)orderedHashSet.get(n);
            DFAState dFAState2 = this.reach(dFAState, label2);
            if (debug) {
                System.out.println("DFA state after reach " + dFAState + "-" + label2.toString(this.dfa.nfa.grammar) + "->" + dFAState2);
            }
            if (dFAState2 == null) continue;
            if (dFAState2.getUniqueAlt() == -1) {
                this.closure(dFAState2);
            }
            DFAState dFAState3 = this.addDFAStateToWorkList(dFAState2);
            n2 += NFAToDFAConverter.addTransition(dFAState, label2, dFAState3, hashMap);
            dFAState3.setLookaheadDepth(dFAState.getLookaheadDepth() + 1);
            if (!dFAState2.abortedDueToMultipleRecursiveAlts || dFAState2.isResolvedWithPredicates()) continue;
            dFAState2.dfa.probe.reportNonLLStarDecision(dFAState2.dfa);
        }
        if (!dFAState.isResolvedWithPredicates() && n2 == 0) {
            this.dfa.probe.reportDanglingState(dFAState);
            n = this.resolveByPickingMinAlt(dFAState, null);
            this.convertToAcceptState(dFAState, n);
        }
        if (dFAState.isResolvedWithPredicates()) {
            this.addPredicateTransitions(dFAState);
        }
    }

    protected static int addTransition(DFAState dFAState, Label label, DFAState dFAState2, Map map) {
        int n = 0;
        if (DFAOptimizer.COLLAPSE_ALL_PARALLEL_EDGES) {
            Integer n2 = Utils.integer(dFAState2.stateNumber);
            Transition transition = (Transition)map.get(n2);
            if (transition != null) {
                if (label.getAtom() == -2) {
                    transition.label = new Label(-2);
                } else if (transition.label.getAtom() != -2) {
                    transition.label.add(label);
                }
            } else {
                n = 1;
                label = (Label)label.clone();
                int n3 = dFAState.addTransition(dFAState2, label);
                Transition transition2 = dFAState.getTransition(n3);
                map.put(n2, transition2);
            }
        } else {
            n = 1;
            dFAState.addTransition(dFAState2, label);
        }
        return n;
    }

    public void closure(DFAState dFAState) {
        if (debug) {
            System.out.println("closure(" + dFAState + ")");
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(dFAState.getNFAConfigurations());
        Iterator iterator = hashSet.iterator();
        while (!dFAState.abortedDueToMultipleRecursiveAlts && iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            if (nFAConfiguration.singleAtomTransitionEmanating) continue;
            this.closure(this.dfa.nfa.getState(nFAConfiguration.state), nFAConfiguration.alt, nFAConfiguration.context, nFAConfiguration.semanticContext, dFAState, false);
        }
        dFAState.closureBusy = null;
    }

    public void closure(NFAState nFAState, int n, NFAContext nFAContext, SemanticContext semanticContext, DFAState dFAState, boolean bl) {
        if (debug) {
            System.out.println("closure at NFA state " + nFAState.stateNumber + "|" + n + " filling DFA state " + dFAState.stateNumber + " with context " + nFAContext);
        }
        if (dFAState.abortedDueToMultipleRecursiveAlts) {
            return;
        }
        if (DFA.MAX_TIME_PER_DFA_CREATION > 0 && System.currentTimeMillis() - dFAState.dfa.conversionStartTime >= (long)DFA.MAX_TIME_PER_DFA_CREATION) {
            this.dfa.probe.reportEarlyTermination();
            return;
        }
        NFAConfiguration nFAConfiguration = new NFAConfiguration(nFAState.stateNumber, n, nFAContext, semanticContext);
        if (NFAToDFAConverter.closureIsBusy(dFAState, nFAConfiguration)) {
            if (debug) {
                System.out.println("avoid visiting exact closure computation NFA config: " + nFAConfiguration);
                System.out.println("state is " + dFAState.dfa.decisionNumber + "." + dFAState);
            }
            return;
        }
        dFAState.closureBusy.add(nFAConfiguration);
        dFAState.addNFAConfiguration(nFAState, nFAConfiguration);
        Transition transition = nFAState.transition(0);
        if (transition instanceof RuleClosureTransition) {
            int n2 = nFAContext.recursionDepthEmanatingFromState(nFAState.stateNumber);
            if (n2 == 1 && dFAState.dfa.getUserMaxLookahead() == 0) {
                dFAState.dfa.recursiveAltSet.add(n);
                if (dFAState.dfa.recursiveAltSet.size() > 1) {
                    dFAState.abortedDueToMultipleRecursiveAlts = true;
                    return;
                }
            }
            if (n2 >= NFAContext.MAX_SAME_RULE_INVOCATIONS_PER_NFA_CONFIG_STACK) {
                dFAState.dfa.probe.reportRecursiveOverflow(dFAState, nFAConfiguration);
                dFAState.abortedDueToRecursionOverflow = true;
                return;
            }
            RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)transition;
            NFAContext nFAContext2 = new NFAContext(nFAContext, nFAState);
            NFAState nFAState2 = (NFAState)ruleClosureTransition.target;
            this.closure(nFAState2, n, nFAContext2, semanticContext, dFAState, bl);
        } else if (nFAState.isAcceptState() && nFAContext.parent != null) {
            NFAState nFAState3 = nFAContext.invokingState;
            RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)nFAState3.transition(0);
            NFAState nFAState4 = ruleClosureTransition.getFollowState();
            NFAContext nFAContext3 = nFAContext.parent;
            this.closure(nFAState4, n, nFAContext3, semanticContext, dFAState, bl);
        } else {
            Object object;
            if (transition != null && transition.isEpsilon()) {
                this.closure((NFAState)transition.target, n, nFAContext, semanticContext, dFAState, bl);
            } else if (transition != null && transition.isSemanticPredicate()) {
                object = semanticContext;
                if (bl) {
                    SemanticContext semanticContext2 = transition.label.getSemanticContext();
                    int n3 = this.dfa.decisionNFAStartState.translateDisplayAltToWalkAlt(this.dfa, n);
                    NFAState nFAState5 = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(this.dfa.decisionNFAStartState, n3);
                    if (!semanticContext2.isSyntacticPredicate() || nFAState == nFAState5.transition((int)0).target) {
                        object = SemanticContext.and(semanticContext, semanticContext2);
                    }
                }
                this.closure((NFAState)transition.target, n, nFAContext, (SemanticContext)object, dFAState, bl);
            }
            object = nFAState.transition(1);
            if (object != null && ((Transition)object).isEpsilon()) {
                this.closure((NFAState)((Transition)object).target, n, nFAContext, semanticContext, dFAState, bl);
            }
        }
    }

    public static boolean closureIsBusy(DFAState dFAState, NFAConfiguration nFAConfiguration) {
        return dFAState.closureBusy.contains(nFAConfiguration);
    }

    public DFAState reach(DFAState dFAState, Label label) {
        DFAState dFAState2 = this.dfa.newState();
        int n = label.getAtom();
        IntSet intSet = label.getSet();
        Iterator iterator = dFAState.getNFAConfigurations().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            NFAState nFAState;
            Transition transition;
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            if (nFAConfiguration.resolved || nFAConfiguration.resolveWithPredicate || (transition = (nFAState = this.dfa.nfa.getState(nFAConfiguration.state)).transition(0)) == null || !nFAConfiguration.singleAtomTransitionEmanating) continue;
            Label label2 = transition.label;
            if (nFAConfiguration.context.parent != null && label2.isAtom() && label2.getAtom() == -2 || !(bl = !label.isSet() && label2.getAtom() == n || !label2.getSet().and(intSet).isNil())) continue;
            dFAState2.addNFAConfiguration((NFAState)transition.target, nFAConfiguration.alt, nFAConfiguration.context, nFAConfiguration.semanticContext);
        }
        if (dFAState2.getNFAConfigurations().size() == 0) {
            this.dfa.setState(dFAState2.stateNumber, null);
            dFAState2 = null;
        }
        return dFAState2;
    }

    protected void convertToEOTAcceptState(DFAState dFAState) {
        Label label = new Label(-2);
        Iterator iterator = dFAState.getNFAConfigurations().iterator();
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            if (nFAConfiguration.resolved || nFAConfiguration.resolveWithPredicate) continue;
            NFAState nFAState = this.dfa.nfa.getState(nFAConfiguration.state);
            Transition transition = nFAState.transition(0);
            Label label2 = transition.label;
            if (!label2.equals(label)) continue;
            dFAState.setAcceptState(true);
            dFAState.getNFAConfigurations().clear();
            dFAState.addNFAConfiguration(nFAState, nFAConfiguration.alt, nFAConfiguration.context, nFAConfiguration.semanticContext);
            return;
        }
    }

    protected DFAState addDFAStateToWorkList(DFAState dFAState) {
        DFAState dFAState2 = this.dfa.addState(dFAState);
        if (dFAState != dFAState2) {
            this.dfa.setState(dFAState.stateNumber, dFAState2);
            return dFAState2;
        }
        this.resolveNonDeterminisms(dFAState);
        int n = dFAState.getUniquelyPredictedAlt();
        if (n != -1) {
            dFAState = this.convertToAcceptState(dFAState, n);
        } else {
            this.work.add(dFAState);
        }
        return dFAState;
    }

    protected DFAState convertToAcceptState(DFAState dFAState, int n) {
        if (DFAOptimizer.MERGE_STOP_STATES && dFAState.getNonDeterministicAlts() == null && !dFAState.abortedDueToRecursionOverflow && !dFAState.abortedDueToMultipleRecursiveAlts) {
            DFAState dFAState2 = this.dfa.getAcceptState(n);
            if (dFAState2 != null) {
                SemanticContext semanticContext = dFAState.getGatedPredicatesInNFAConfigurations();
                SemanticContext semanticContext2 = dFAState2.getGatedPredicatesInNFAConfigurations();
                if (semanticContext == null && semanticContext2 == null || semanticContext != null && semanticContext2 != null && semanticContext.equals(semanticContext2)) {
                    this.dfa.setState(dFAState.stateNumber, dFAState2);
                    this.dfa.removeState(dFAState);
                    dFAState = dFAState2;
                    return dFAState;
                }
            }
            dFAState.setAcceptState(true);
            this.dfa.setAcceptState(n, dFAState);
            return dFAState;
        }
        dFAState.setAcceptState(true);
        this.dfa.setAcceptState(n, dFAState);
        return dFAState;
    }

    public void resolveNonDeterminisms(DFAState dFAState) {
        boolean bl;
        Set set;
        if (debug) {
            System.out.println("resolveNonDeterminisms " + dFAState.toString());
        }
        boolean bl2 = false;
        Set set2 = dFAState.getNonDeterministicAlts();
        if (debug && set2 != null) {
            System.out.println("nondet alts=" + set2);
        }
        Iterator iterator = dFAState.nfaConfigurations.iterator();
        NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
        NFAState nFAState = this.dfa.nfa.getState(nFAConfiguration.state);
        if (nFAState.isEOTTargetState() && (set = dFAState.getAltSet()) != null && set.size() > 1) {
            set2 = set;
            if (dFAState.dfa.isTokensRuleDecision()) {
                this.dfa.probe.reportLexerRuleNondeterminism(dFAState, set);
                bl2 = true;
            }
        }
        if (!dFAState.abortedDueToRecursionOverflow && set2 == null) {
            return;
        }
        if (!dFAState.abortedDueToRecursionOverflow && !bl2) {
            this.dfa.probe.reportNondeterminism(dFAState, set2);
        }
        if (bl = this.tryToResolveWithSemanticPredicates(dFAState, set2)) {
            dFAState.resolvedWithPredicates = true;
            this.dfa.probe.reportNondeterminismResolvedWithSemanticPredicate(dFAState);
            return;
        }
        this.resolveByChoosingFirstAlt(dFAState, set2);
    }

    protected int resolveByChoosingFirstAlt(DFAState dFAState, Set set) {
        int n;
        int n2 = 0;
        n2 = this.dfa.isGreedy() ? this.resolveByPickingMinAlt(dFAState, set) : (set.contains(Utils.integer(n = this.dfa.getNumberOfAlts())) ? this.resolveByPickingExitAlt(dFAState, set) : this.resolveByPickingMinAlt(dFAState, set));
        return n2;
    }

    protected int resolveByPickingMinAlt(DFAState dFAState, Set set) {
        int n = Integer.MAX_VALUE;
        n = set != null ? NFAToDFAConverter.getMinAlt(set) : NFAToDFAConverter.getMinAlt(dFAState);
        NFAToDFAConverter.turnOffOtherAlts(dFAState, n, set);
        return n;
    }

    protected int resolveByPickingExitAlt(DFAState dFAState, Set set) {
        int n = this.dfa.getNumberOfAlts();
        NFAToDFAConverter.turnOffOtherAlts(dFAState, n, set);
        return n;
    }

    protected static void turnOffOtherAlts(DFAState dFAState, int n, Set set) {
        Iterator iterator = dFAState.nfaConfigurations.iterator();
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            if (nFAConfiguration.alt == n || set != null && !set.contains(Utils.integer(nFAConfiguration.alt))) continue;
            nFAConfiguration.resolved = true;
        }
    }

    protected static int getMinAlt(DFAState dFAState) {
        int n = Integer.MAX_VALUE;
        Iterator iterator = dFAState.nfaConfigurations.iterator();
        while (iterator.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
            if (nFAConfiguration.alt >= n) continue;
            n = nFAConfiguration.alt;
        }
        return n;
    }

    protected static int getMinAlt(Set set) {
        int n = Integer.MAX_VALUE;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            int n3 = n2;
            if (n3 >= n) continue;
            n = n3;
        }
        return n;
    }

    protected boolean tryToResolveWithSemanticPredicates(DFAState dFAState, Set set) {
        Object object;
        Object object2;
        Map map = this.getPredicatesPerNonDeterministicAlt(dFAState, set);
        if (map.size() == 0) {
            return false;
        }
        this.dfa.probe.reportAltPredicateContext(dFAState, map);
        if (set.size() - map.size() > 1) {
            return false;
        }
        if (map.size() == set.size() - 1) {
            Object object3;
            object2 = BitSet.of(set);
            object = BitSet.of(map);
            int n = ((BitSet)object2).subtract((IntSet)object).getSingleElement();
            SemanticContext semanticContext = null;
            semanticContext = n == NFAToDFAConverter.max(set) ? new SemanticContext.TruePredicate() : (((SemanticContext)(object3 = NFAToDFAConverter.getUnionOfPredicates(map))).isSyntacticPredicate() ? new SemanticContext.TruePredicate() : SemanticContext.not((SemanticContext)object3));
            map.put(Utils.integer(n), semanticContext);
            object3 = dFAState.nfaConfigurations.iterator();
            while (object3.hasNext()) {
                NFAConfiguration nFAConfiguration = (NFAConfiguration)object3.next();
                if (nFAConfiguration.alt != n) continue;
                nFAConfiguration.semanticContext = semanticContext;
            }
        }
        if (map.size() == set.size()) {
            if (dFAState.abortedDueToRecursionOverflow) {
                dFAState.dfa.probe.removeRecursiveOverflowState(dFAState);
            }
            object2 = dFAState.nfaConfigurations.iterator();
            while (object2.hasNext()) {
                object = (NFAConfiguration)object2.next();
                SemanticContext semanticContext = (SemanticContext)map.get(Utils.integer(((NFAConfiguration)object).alt));
                if (semanticContext != null) {
                    ((NFAConfiguration)object).resolveWithPredicate = true;
                    ((NFAConfiguration)object).semanticContext = semanticContext;
                    map.remove(Utils.integer(((NFAConfiguration)object).alt));
                    if (!semanticContext.isSyntacticPredicate()) continue;
                    this.dfa.nfa.grammar.synPredUsedInDFA(this.dfa, semanticContext);
                    continue;
                }
                if (!set.contains(Utils.integer(((NFAConfiguration)object).alt))) continue;
                ((NFAConfiguration)object).resolved = true;
            }
            return true;
        }
        return false;
    }

    protected Map getPredicatesPerNonDeterministicAlt(DFAState dFAState, Set set) {
        Object object;
        Serializable serializable;
        Object object2;
        HashMap<Integer, SemanticContext> hashMap = new HashMap<Integer, SemanticContext>();
        HashMap hashMap2 = new HashMap();
        Object object3 = set.iterator();
        while (object3.hasNext()) {
            object2 = (Integer)object3.next();
            hashMap2.put((Integer)object2, new HashSet());
        }
        object3 = new HashSet();
        object2 = dFAState.nfaConfigurations.iterator();
        while (object2.hasNext()) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)object2.next();
            serializable = Utils.integer(nFAConfiguration.alt);
            if (!set.contains(serializable)) continue;
            if (nFAConfiguration.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) {
                object = (Set)hashMap2.get(serializable);
                object.add(nFAConfiguration.semanticContext);
                continue;
            }
            object3.add(serializable);
        }
        serializable = new ArrayList();
        object = set.iterator();
        while (object.hasNext()) {
            SemanticContext semanticContext;
            Integer n = (Integer)object.next();
            Set set2 = (Set)hashMap2.get(n);
            if (object3.contains(n)) {
                semanticContext = (SemanticContext)hashMap.get(n);
                if (set2.size() <= 0) continue;
                serializable.add(n);
                continue;
            }
            semanticContext = null;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                SemanticContext semanticContext2 = (SemanticContext)iterator.next();
                semanticContext = SemanticContext.or(semanticContext, semanticContext2);
            }
            hashMap.put(n, semanticContext);
        }
        if (serializable.size() > 0) {
            this.dfa.probe.reportIncompletelyCoveredAlts(dFAState, (List)((Object)serializable));
        }
        return hashMap;
    }

    protected static SemanticContext getUnionOfPredicates(Map map) {
        SemanticContext semanticContext = null;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            SemanticContext semanticContext2 = (SemanticContext)iterator.next();
            if (semanticContext == null) {
                semanticContext = semanticContext2;
                continue;
            }
            semanticContext = SemanticContext.or(semanticContext, semanticContext2);
        }
        return semanticContext;
    }

    protected void addPredicateTransitions(DFAState dFAState) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = dFAState.getNFAConfigurations().iterator();
        while (iterator.hasNext()) {
            object = (NFAConfiguration)iterator.next();
            if (!((NFAConfiguration)object).resolveWithPredicate) continue;
            arrayList.add(object);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                NFAConfiguration nFAConfiguration = (NFAConfiguration)object;
                NFAConfiguration nFAConfiguration2 = (NFAConfiguration)object2;
                if (nFAConfiguration.alt < nFAConfiguration2.alt) {
                    return -1;
                }
                if (nFAConfiguration.alt > nFAConfiguration2.alt) {
                    return 1;
                }
                return 0;
            }
        });
        object = arrayList;
        for (int i = 0; i < object.size(); ++i) {
            NFAConfiguration nFAConfiguration = (NFAConfiguration)object.get(i);
            DFAState dFAState2 = dFAState.dfa.getAcceptState(nFAConfiguration.alt);
            if (dFAState2 == null) {
                dFAState2 = this.dfa.newState();
                dFAState2.addNFAConfiguration(this.dfa.nfa.getState(nFAConfiguration.state), nFAConfiguration.alt, nFAConfiguration.context, nFAConfiguration.semanticContext);
                dFAState2.setAcceptState(true);
                DFAState dFAState3 = this.dfa.addState(dFAState2);
                if (dFAState2 != dFAState3) {
                    this.dfa.setState(dFAState2.stateNumber, dFAState3);
                    dFAState2 = dFAState3;
                }
            }
            dFAState.addTransition(dFAState2, new Label(nFAConfiguration.semanticContext));
        }
    }

    protected void initContextTrees(int n) {
        this.contextTrees = new NFAContext[n];
        for (int i = 0; i < this.contextTrees.length; ++i) {
            int n2 = i + 1;
            this.contextTrees[i] = new NFAContext(null, null);
        }
    }

    public static int max(Set set) {
        if (set == null) {
            return Integer.MIN_VALUE;
        }
        int n = 0;
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n3 = (Integer)iterator.next();
            if (++n == 1) {
                n2 = n3;
                continue;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }
}

