/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.mortbay.util.IO;

public class Files {
    public static boolean delTree(File dir2) {
        try {
            File[] contents;
            if (dir2.isDirectory() && (contents = dir2.listFiles()).length > 0) {
                for (int i = 0; i < contents.length; ++i) {
                    Files.delTree(contents[i]);
                }
            }
            return dir2.delete();
        }
        catch (SecurityException se) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToBytes(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("parameter file is null.");
        }
        FileInputStream s = new FileInputStream(file);
        try {
            byte[] byArray = Files.inputStreamToBytes(new FileInputStream(file));
            return byArray;
        }
        finally {
            ((InputStream)s).close();
        }
    }

    public static byte[] inputStreamToBytes(InputStream input) throws IOException {
        if (input == null) {
            throw new NullPointerException("parameter input is null.");
        }
        BufferedInputStream in = new BufferedInputStream(input);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(in, out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToString(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("parameter file is null.");
        }
        FileInputStream s = new FileInputStream(file);
        try {
            String string = Files.inputStreamToString(new FileInputStream(file));
            return string;
        }
        finally {
            ((InputStream)s).close();
        }
    }

    public static String inputStreamToString(InputStream input) throws IOException {
        if (input == null) {
            throw new NullPointerException("parameter input is null.");
        }
        StringBuffer buffer = new StringBuffer();
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(input));
        String line = inputReader.readLine();
        while (line != null) {
            buffer.append(line + "\n");
            line = inputReader.readLine();
        }
        return buffer.toString();
    }

    public static boolean sweepAndCreateDirectory(File dir2) {
        if (dir2.exists()) {
            if (!dir2.isDirectory()) {
                return false;
            }
            if (!Files.delTree(dir2)) {
                return false;
            }
        }
        return dir2.mkdir();
    }

    public static boolean equalInputStreamContent(InputStream input1, InputStream input2) throws IOException {
        BufferedInputStream in1 = new BufferedInputStream(input1);
        BufferedInputStream in2 = new BufferedInputStream(input2);
        boolean equal = true;
        int byte1 = ((InputStream)in1).read();
        while (byte1 != -1 && equal) {
            if (byte1 != ((InputStream)in2).read()) {
                equal = false;
            }
            byte1 = ((InputStream)in1).read();
        }
        if (((InputStream)in2).read() != -1) {
            equal = false;
        }
        return equal;
    }

    public static void cleanOldFiles(File baseDir, long cutoff) {
        Files.walkAndDelete(baseDir, new AgeFileFilter(System.currentTimeMillis() - cutoff));
    }

    public static void walkAndDelete(File baseDir, IOFileFilter filter) {
        File[] files = baseDir.listFiles(new OrFileFilter(DirectoryFileFilter.INSTANCE, filter));
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                boolean toBeDeleted = false;
                if (filter.accept(f)) {
                    toBeDeleted = true;
                }
                Files.walkAndDelete(f, filter);
                if (!toBeDeleted) continue;
                f.delete();
                continue;
            }
            f.delete();
        }
    }

    public static String[] parseFilename(File file) {
        String extension;
        String name;
        String path = file.getParent() != null ? file.getParent() : "";
        String wholeName = file.getName();
        if (wholeName.contains(".")) {
            name = wholeName.substring(0, wholeName.indexOf(46));
            extension = wholeName.substring(wholeName.indexOf(46) + 1);
        } else {
            name = wholeName;
            extension = "";
        }
        return new String[]{path, name, extension};
    }
}

