/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.message.NamiMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.log4j.Logger;

public class MessageListenerWrapper
implements MessageListener {
    private static final Logger logger = Logger.getLogger(MessageListenerWrapper.class);
    private MessagingListener actualListener;

    public MessageListenerWrapper(MessagingListener listener) {
        this.actualListener = listener;
    }

    public void onMessage(Message msg) {
        try {
            String msgClass = msg.getStringProperty("class");
            logger.debug("message received, class is " + msgClass);
            MapMessage mapMessage = (MapMessage)msg;
            NamiMessage namiMessage = (NamiMessage)Class.forName(msgClass).newInstance();
            namiMessage.unmarshal(mapMessage);
            this.actualListener.onNamiMessage(namiMessage);
        }
        catch (Exception e) {
            logger.error(e, e);
        }
    }
}

