/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.fs;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationCategory;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.fs.FSDataBean;
import fi.csc.microarray.databeans.fs.FSDataFolder;
import fi.csc.microarray.databeans.fs.FSDataManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSnapshottingSession {
    private final int DATA_BLOCK_SIZE = 2048;
    private static final String METADATA_FILENAME = "snapshot_metadata.txt";
    public static final String SNAPSHOT_EXTENSION = "cs";
    private final int SNAPSHOT_VERSION = 2;
    private static final String ROOT_FOLDER_ID = "0";
    private FSDataManager manager;
    private ClientApplication application;
    private int itemIdCounter = 0;
    private HashMap<Integer, DataItem> itemIdMap = new HashMap();
    private HashMap<DataItem, Integer> reversedItemIdMap = new HashMap();
    private int operationIdCounter = 0;
    private HashMap<Integer, Operation> operationIdMap = new HashMap();
    private HashMap<Operation, Integer> reversedOperationIdMap = new HashMap();
    private ZipOutputStream cpZipOutputStream = null;

    public FSSnapshottingSession(FSDataManager manager, ClientApplication application) {
        this.manager = manager;
        this.application = application;
    }

    public int saveSnapshot(File snapshot) throws IOException {
        FileOutputStream fos = new FileOutputStream(snapshot);
        this.cpZipOutputStream = new ZipOutputStream(fos);
        this.cpZipOutputStream.setLevel(1);
        StringBuffer metadata = new StringBuffer("");
        metadata.append("VERSION 2\n");
        int dataCount = this.saveRecursively((FSDataFolder)this.manager.getRootFolder(), this.cpZipOutputStream, metadata);
        this.saveLinksRecursively((FSDataFolder)this.manager.getRootFolder(), metadata);
        this.writeFile(this.cpZipOutputStream, METADATA_FILENAME, new ByteArrayInputStream(metadata.toString().getBytes()));
        this.cpZipOutputStream.finish();
        this.cpZipOutputStream.close();
        return dataCount;
    }

    private void writeFile(ZipOutputStream out, String name, InputStream in) throws IOException {
        int byteCount;
        ZipEntry cpZipEntry = new ZipEntry(name);
        this.cpZipOutputStream.putNextEntry(cpZipEntry);
        byte[] b = new byte[2048];
        while ((byteCount = in.read(b, 0, 2048)) != -1) {
            this.cpZipOutputStream.write(b, 0, byteCount);
        }
        this.cpZipOutputStream.closeEntry();
    }

    private void saveLinksRecursively(FSDataFolder folder, StringBuffer metadata) {
        for (DataItem data : folder.getChildren()) {
            if (data instanceof FSDataFolder) {
                this.saveLinksRecursively((FSDataFolder)data, metadata);
                continue;
            }
            DataBean bean = (DataBean)data;
            for (DataBean.Link type : DataBean.Link.values()) {
                for (DataBean target : bean.getLinkTargets(type)) {
                    String beanId = this.fetchId(bean);
                    String targetId = this.fetchId(target);
                    metadata.append("LINK " + type.name() + " " + beanId + " " + targetId + "\n");
                }
            }
        }
    }

    private int saveRecursively(FSDataFolder folder, ZipOutputStream cpZipOutputStream, StringBuffer metadata) throws IOException {
        int dataCount = 0;
        String folderId = this.generateId(folder);
        this.saveDataFolderMetadata(folder, folderId, metadata);
        for (DataItem data : folder.getChildren()) {
            if (data instanceof FSDataFolder) {
                int recDataCount = this.saveRecursively((FSDataFolder)data, cpZipOutputStream, metadata);
                dataCount += recDataCount;
                continue;
            }
            FSDataBean bean = (FSDataBean)data;
            this.saveDataBeanMetadata(bean, folderId, metadata);
            this.writeFile(cpZipOutputStream, bean.getContentFile().getName(), new FileInputStream(bean.getContentFile()));
            ++dataCount;
        }
        return dataCount;
    }

    private void saveDataFolderMetadata(FSDataFolder folder, String folderId, StringBuffer metadata) {
        metadata.append("DATAFOLDER " + folderId + "\n");
        this.saveDataItemMetadata(folder, folderId, metadata);
    }

    private void saveDataBeanMetadata(FSDataBean bean, String folderId, StringBuffer metadata) {
        String beanId = this.generateId(bean);
        metadata.append("DATABEAN " + beanId + " " + bean.getContentFile().getName() + "\n");
        if (bean.getOperation() != null) {
            String operId;
            Operation operation = bean.getOperation();
            if (!this.operationIdMap.containsValue(operation)) {
                operId = this.generateId(operation);
                metadata.append("OPERATION " + operId + " " + operation.getCategoryName() + "/" + operation.getName() + "\n");
                if (operation.getBindings() != null) {
                    String beanIds = "";
                    for (Operation.DataBinding binding : operation.getBindings()) {
                        beanIds = beanIds + this.fetchId(binding.getData()) + " ";
                    }
                    metadata.append("INPUTS " + operId + " " + beanIds + "\n");
                }
                for (Parameter parameter : operation.getParameters()) {
                    metadata.append("OPERATION_PARAMETER " + operId + " " + parameter.getName() + " " + parameter.getValue() + "\n");
                }
            } else {
                operId = this.reversedOperationIdMap.get(operation).toString();
            }
            metadata.append("OUTPUT " + operId + " " + beanId + "\n");
        }
        if (bean.getNotes() != null) {
            metadata.append("NOTES " + beanId + " " + bean.getNotes().replace('\n', ' ') + "\n");
        }
        if (bean.getCachedURL() != null) {
            metadata.append("CACHED_URL " + beanId + " " + bean.getCachedURL() + "\n");
        }
        this.saveDataItemMetadata(bean, beanId, metadata);
    }

    private void saveDataItemMetadata(DataItem data, String folderId, StringBuffer metadata) {
        metadata.append("NAME " + folderId + " " + data.getName() + "\n");
        if (data.getParent() != null) {
            metadata.append("CHILD " + folderId + " " + this.fetchId(data.getParent()) + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataItem> loadFromSnapshot(File snapshot, DataFolder parentFolder) throws IOException, MicroarrayException {
        ZipFile zipFile = new ZipFile(snapshot);
        ZipEntry entry = null;
        HashMap<String, ZipEntry> entryMap = new HashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            entryMap.put(entry.getName(), entry);
        }
        LinkedList<DataItem> newItems = new LinkedList<DataItem>();
        LinkedList<String> delayedProcessing = new LinkedList<String>();
        BufferedReader metadataIn = null;
        try {
            metadataIn = new BufferedReader(new InputStreamReader(zipFile.getInputStream((ZipEntry)entryMap.get(METADATA_FILENAME))));
            String firstLine = metadataIn.readLine();
            String supportedVersionLine = "VERSION 2";
            if (!firstLine.contains(supportedVersionLine)) {
                throw new RuntimeException("unsupported stored session format: should be \"" + supportedVersionLine + "\", but was \"" + firstLine.replace("\n", "") + "\"");
            }
            String line = metadataIn.readLine();
            while (line != null) {
                DataItem item;
                DataBean bean;
                String id;
                String[] split;
                if (line.startsWith("DATAFOLDER ")) {
                    split = line.split(" ");
                    id = split[1];
                    DataFolder folder = this.manager.createFolder("");
                    newItems.add(folder);
                    this.mapId(id, folder);
                } else if (line.startsWith("DATABEAN ")) {
                    split = line.split(" ");
                    id = split[1];
                    ZipEntry beanEntry = (ZipEntry)entryMap.get(split[2]);
                    InputStream inputStream = zipFile.getInputStream(beanEntry);
                    bean = this.manager.createDataBean("<empty>", inputStream);
                    newItems.add(bean);
                    this.mapId(id, bean);
                } else if (line.startsWith("NAME ")) {
                    split = line.split(" ");
                    id = split[1];
                    String name = FSSnapshottingSession.afterNthSpace(line, 2);
                    item = this.fetchItem(id);
                    item.setName(name);
                    if (item instanceof DataBean) {
                        bean = (DataBean)item;
                        bean.setContentType(this.manager.guessContentType(name));
                    }
                } else if (line.startsWith("OPERATION ")) {
                    split = line.split(" ");
                    id = split[1];
                    String[] opData = FSSnapshottingSession.afterNthSpace(line, 2).split("/");
                    OperationDefinition od = this.application.locateOperationDefinition(opData[0], opData[1]);
                    Operation op = null;
                    if (od == null) {
                        od = new OperationDefinition(opData[1], new OperationCategory(opData[0]), "", false);
                    }
                    op = new Operation(od, new DataBean[0]);
                    this.mapId(id, op);
                } else if (line.startsWith("OPERATION_PARAMETER ")) {
                    delayedProcessing.add(line);
                } else if (line.startsWith("OUTPUT ")) {
                    split = line.split(" ");
                    String operId = split[1];
                    Operation operation = this.fetchOperation(operId);
                    String beanId = split[2];
                    bean = (DataBean)this.fetchItem(beanId);
                    bean.setOperation(operation);
                } else if (line.startsWith("INPUTS ")) {
                    delayedProcessing.add(line);
                } else if (line.startsWith("CHILD ")) {
                    split = line.split(" ");
                    String childId = split[1];
                    String parentId = split[2];
                    DataFolder parent = parentId.equals(ROOT_FOLDER_ID) ? this.manager.getRootFolder() : (DataFolder)this.fetchItem(parentId);
                    DataItem child = this.fetchItem(childId);
                    parent.addChild(child);
                } else if (line.startsWith("NOTES ")) {
                    split = line.split(" ");
                    id = split[1];
                    String notes = FSSnapshottingSession.afterNthSpace(line, 2);
                    item = (DataBean)this.fetchItem(id);
                    item.setNotes(notes);
                } else if (line.startsWith("CACHED_URL ")) {
                    split = line.split(" ");
                    id = split[1];
                    String url = split[2];
                    FSDataBean bean2 = (FSDataBean)this.fetchItem(id);
                    bean2.resetContentChanged();
                    bean2.setCachedURL(new URL(url));
                } else if (line.startsWith("LINK ")) {
                    split = line.split(" ");
                    DataBean.Link link = DataBean.Link.valueOf(split[1]);
                    String fromId = split[2];
                    String toId = split[3];
                    DataBean from = (DataBean)this.fetchItem(fromId);
                    DataBean to = (DataBean)this.fetchItem(toId);
                    from.addLink(link, to);
                } else {
                    throw new RuntimeException("metadata error in " + snapshot.getCanonicalPath() + ": line could not be processed \"" + line + "\"");
                }
                line = metadataIn.readLine();
            }
        }
        finally {
            if (metadataIn != null) {
                metadataIn.close();
            }
        }
        for (String line : delayedProcessing) {
            String operId;
            String[] split;
            if (line.startsWith("OPERATION_PARAMETER ")) {
                split = line.split(" ");
                operId = split[1];
                String paramName = split[2];
                String paramValue = split[3];
                Operation operation = this.fetchOperation(operId);
                Parameter parameter = operation.getParameter(paramName);
                if (parameter != null) {
                    parameter.parseValue(paramValue);
                    continue;
                }
                String title = "Obsolete analysis tool parameter.";
                String message = "The session you opened contains a dataset which has been derived using an analysis tool with a parameter which has been removed or renamed.\n\nThe dataset contents have not changed and you can use them as before, but the obsolete parameter has been removed from the history information of the dataset and will not be saved in further sessions or workflows.";
                String details = "Analysis tool: " + operation.getCategoryName() + " / " + operation.getName() + "\nObsolete parameter: " + paramName;
                this.application.showDialog(title, message, details, DialogInfo.Severity.INFO, true, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_VISIBLE);
                continue;
            }
            if (line.startsWith("INPUTS ")) {
                split = line.split(" ");
                operId = split[1];
                Operation operation = this.fetchOperation(operId);
                LinkedList<DataBean> inputs = new LinkedList<DataBean>();
                for (int i = 2; i < split.length; ++i) {
                    String beanId = split[i];
                    DataBean bean = (DataBean)this.fetchItem(beanId);
                    if (bean.queryFeatures("/phenodata/").exists()) continue;
                    inputs.add(bean);
                }
                operation.bindInputs(inputs.toArray(new DataBean[0]));
                continue;
            }
            throw new RuntimeException("internal error, cannot parse: " + line);
        }
        return newItems;
    }

    private static String afterNthSpace(String line, int nth) {
        int from = 0;
        for (int i = 0; i < nth; ++i) {
            from = line.indexOf(" ", from + 1);
        }
        return line.substring(from + 1);
    }

    private void mapId(String id, DataItem item) {
        Integer iid = Integer.parseInt(id);
        this.itemIdMap.put(iid, item);
        this.reversedItemIdMap.put(item, iid);
    }

    private void mapId(String id, Operation operation) {
        Integer iid = Integer.parseInt(id);
        this.operationIdMap.put(iid, operation);
        this.reversedOperationIdMap.put(operation, iid);
    }

    private String generateId(DataItem data) {
        Integer id = this.itemIdCounter++;
        this.itemIdMap.put(id, data);
        this.reversedItemIdMap.put(data, id);
        return id.toString();
    }

    private String generateId(Operation operation) {
        Integer id = this.operationIdCounter++;
        this.operationIdMap.put(id, operation);
        this.reversedOperationIdMap.put(operation, id);
        return id.toString();
    }

    private DataItem fetchItem(String id) {
        Integer iid = Integer.parseInt(id);
        return this.itemIdMap.get(iid);
    }

    private Operation fetchOperation(String id) {
        Integer iid = Integer.parseInt(id);
        return this.operationIdMap.get(iid);
    }

    private String fetchId(DataItem item) {
        return this.reversedItemIdMap.get(item).toString();
    }
}

