/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.bio;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.LinkUtils;
import fi.csc.microarray.databeans.features.BoolFalseFeature;
import fi.csc.microarray.databeans.features.BoolTrueFeature;
import fi.csc.microarray.databeans.features.ConstantStringFeature;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureProviderBase;
import fi.csc.microarray.databeans.features.QueryResult;
import fi.csc.microarray.databeans.features.Table;

public class PhenodataProvider
extends FeatureProviderBase {
    private static final String CONVERSION_NAMEFRAGMENT = "_to_";
    private static final String LINKED_PHENODATA_NAME = "linked";

    public Feature createFeature(String namePostfix, DataBean bean) {
        String namePostPostFix;
        DataBean phenoBean;
        if (namePostfix.startsWith(LINKED_PHENODATA_NAME)) {
            phenoBean = LinkUtils.retrieveInherited(bean, DataBean.Link.ANNOTATION);
            namePostPostFix = namePostfix.substring(LINKED_PHENODATA_NAME.length());
        } else {
            phenoBean = bean;
            namePostPostFix = namePostfix;
        }
        if (namePostfix.contains(CONVERSION_NAMEFRAGMENT)) {
            return this.createConversionFeature(namePostPostFix, phenoBean);
        }
        return this.createBooleanFeature(namePostPostFix, phenoBean);
    }

    private Feature createBooleanFeature(String namePostfix, DataBean bean) {
        boolean isPhenodata = false;
        boolean isComplete = false;
        if (bean.queryFeatures("/column/sample").exists() && bean.queryFeatures("/column/chiptype").exists()) {
            isPhenodata = true;
            try {
                boolean hasEmptyGroups = false;
                QueryResult groupFeature = bean.queryFeatures("/column/group");
                if (groupFeature.exists()) {
                    Iterable<String> groups = bean.queryFeatures("/column/group").asStrings();
                    for (String group : groups) {
                        if (!"".equals(group.trim())) continue;
                        hasEmptyGroups = true;
                        break;
                    }
                    isComplete = !hasEmptyGroups;
                }
            }
            catch (MicroarrayException e) {
                throw new RuntimeException(e);
            }
        }
        boolean returnValue = "is-complete".equals(namePostfix) ? isComplete : isPhenodata;
        return returnValue ? new BoolTrueFeature(bean, this) : new BoolFalseFeature(bean, this);
    }

    private Feature createConversionFeature(String namePostfix, DataBean bean) {
        String originalName;
        block6: {
            String sampleName;
            originalName = sampleName = namePostfix.substring(namePostfix.lastIndexOf(47) + 1);
            if (bean != null) {
                try {
                    Table table = bean.queryFeatures("/column/*").asTable();
                    if (table == null) break block6;
                    if (table.hasColumn("description")) {
                        while (table.nextRow()) {
                            if (!sampleName.equals(table.getStringValue("sample"))) continue;
                            originalName = table.getStringValue("description");
                            break block6;
                        }
                        break block6;
                    }
                    if (!table.hasColumn("original_name")) break block6;
                    while (table.nextRow()) {
                        if (!sampleName.equals(table.getStringValue("sample"))) continue;
                        originalName = table.getStringValue("original_name");
                        break;
                    }
                }
                catch (MicroarrayException e) {
                    // empty catch block
                }
            }
        }
        return new ConstantStringFeature(bean, this, originalName);
    }
}

