/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.methods.threed.Projection;
import fi.csc.microarray.client.visualisation.methods.threed.Worker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.Random;

public class AutomatedMovement
extends Thread {
    private Projection projection;
    private Worker worker;
    private LinkedList<Task> taskQueue;
    RotationTask rotationTask;
    Task task;
    private boolean kill;

    public AutomatedMovement(Projection projection, Worker worker) {
        this.projection = projection;
        this.worker = worker;
        this.taskQueue = new LinkedList();
        Session.getSession().getApplication().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt instanceof VisualisationMethodChangedEvent) {
                    AutomatedMovement.this.kill();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTranslationTask(double[] point, long time, double fps) {
        LinkedList<Task> linkedList = this.taskQueue;
        synchronized (linkedList) {
            this.taskQueue.addLast(new TranslationTask(point, time, fps));
            this.taskQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAutomatedRotation() {
        LinkedList<Task> linkedList = this.taskQueue;
        synchronized (linkedList) {
            this.clearTasks();
            this.taskQueue.addLast(new AutomatedRotation());
            this.taskQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRotationTask(double xRotation, double yRotation, double zRotation, long time, double fps) {
        LinkedList<Task> linkedList = this.taskQueue;
        synchronized (linkedList) {
            this.clearTasks();
            this.taskQueue.addLast(new RotationTask(xRotation, yRotation, zRotation, time, fps));
            this.taskQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RotationTask startKineticMove(double fps, double retardation) {
        LinkedList<Task> linkedList = this.taskQueue;
        synchronized (linkedList) {
            this.clearTasks();
            this.rotationTask = new RotationTask(0.0, 0.0, 0.0, fps, retardation);
            this.taskQueue.addLast(this.rotationTask);
            this.taskQueue.notify();
        }
        return this.rotationTask;
    }

    public void clearTasks() {
        while (this.taskQueue.size() > 0) {
            this.taskQueue.remove();
        }
        if (this.task != null) {
            this.task.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RotationTask restartKineticMove() {
        LinkedList<Task> linkedList = this.taskQueue;
        synchronized (linkedList) {
            while (this.taskQueue.size() > 0) {
                this.taskQueue.remove();
            }
            this.taskQueue.addLast(this.rotationTask);
            this.taskQueue.notify();
        }
        return this.rotationTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.kill) {
            LinkedList<Task> linkedList = this.taskQueue;
            synchronized (linkedList) {
                while (this.taskQueue.isEmpty()) {
                    try {
                        this.taskQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.task = this.taskQueue.poll();
                this.taskQueue.notify();
            }
            this.task.doTask();
            this.task = null;
        }
    }

    public void kill() {
        this.clearTasks();
        this.kill = true;
    }

    private class AutomatedRotation
    extends Task {
        boolean autoRotationKill;
        boolean autoRotationIsRunning;
        double x;
        double y;
        double z;
        double angle;
        final double SPEED = 0.01;
        Random rand;

        private AutomatedRotation() {
            this.autoRotationKill = false;
            this.autoRotationIsRunning = false;
            this.x = AutomatedMovement.this.projection.getXAxisRotation();
            this.y = AutomatedMovement.this.projection.getYAxisRotation();
            this.z = AutomatedMovement.this.projection.getZAxisRotation();
            this.angle = 4.71238898038469;
            this.SPEED = 0.01;
            this.rand = new Random();
        }

        public void doTask() {
            this.autoRotationIsRunning = true;
            while (!this.autoRotationKill) {
                AutomatedMovement.this.projection.setXAxisRotation(this.x);
                AutomatedMovement.this.projection.setYAxisRotation(this.y);
                AutomatedMovement.this.projection.setZAxisRotation(this.z);
                this.x += Math.cos(this.angle) * 0.01;
                this.y += Math.sin(this.angle) * 0.01;
                this.angle += (this.rand.nextDouble() - 0.5) * 0.1;
                AutomatedMovement.this.worker.workRequest();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.autoRotationIsRunning = false;
            this.autoRotationKill = false;
        }

        public void stop() {
            if (this.autoRotationIsRunning) {
                this.autoRotationKill = true;
            }
        }
    }

    public class RotationTask
    extends Task {
        double ticks;
        double timeIncrement;
        double xAngleInc;
        double yAngleInc;
        double zAngleInc;
        double retardation;

        public RotationTask(double xRotation, double yRotation, double zRotation, long time, double fps) {
            this.retardation = 1.0;
            this.ticks = (double)time / 1000.0 * fps;
            this.timeIncrement = 1000.0 / fps;
            this.xAngleInc = (xRotation - AutomatedMovement.this.projection.getXAxisRotation()) / this.ticks;
            this.yAngleInc = (yRotation - AutomatedMovement.this.projection.getYAxisRotation()) / this.ticks;
            this.zAngleInc = (zRotation - AutomatedMovement.this.projection.getZAxisRotation()) / this.ticks;
        }

        public RotationTask(double xAngleInc, double yAngleInc, double zAngleInc, double fps, double retardation) {
            this.retardation = 1.0;
            this.ticks = 9.223372036854776E18;
            this.timeIncrement = 1000.0 / fps;
            this.retardation = retardation;
            this.xAngleInc = xAngleInc;
            this.yAngleInc = yAngleInc;
            this.zAngleInc = zAngleInc;
        }

        public void setAngleIncs(double xAngleInc, double yAngleInc, double zAngleInc) {
            this.ticks = 9.223372036854776E18;
            this.xAngleInc = xAngleInc;
            this.yAngleInc = yAngleInc;
            this.zAngleInc = zAngleInc;
        }

        public void stop() {
            this.ticks = -1.0;
        }

        public void doTask() {
            int i = 0;
            while ((double)i < this.ticks) {
                AutomatedMovement.this.projection.setXAxisRotation(AutomatedMovement.this.projection.getXAxisRotation() + this.xAngleInc);
                AutomatedMovement.this.projection.setYAxisRotation(AutomatedMovement.this.projection.getYAxisRotation() + this.yAngleInc);
                AutomatedMovement.this.projection.setZAxisRotation(AutomatedMovement.this.projection.getZAxisRotation() + this.zAngleInc);
                AutomatedMovement.this.worker.workRequest();
                this.xAngleInc *= this.retardation;
                this.yAngleInc *= this.retardation;
                this.zAngleInc *= this.retardation;
                try {
                    Thread.sleep((long)this.timeIncrement);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private class TranslationTask
    extends Task {
        private double[] point;
        private long time;
        private double fps;

        public TranslationTask(double[] point, long time, double fps) {
            this.point = point;
            this.time = time;
            this.fps = fps;
        }

        public void stop() {
        }

        public void doTask() {
            double ticks = (double)this.time / 1000.0 * this.fps;
            double timeIncrement = 1000.0 / this.fps;
            double[] placeIncrement = new double[]{this.point[0] / ticks, this.point[1] / ticks, this.point[2] / ticks};
            int i = 0;
            while ((double)i < ticks) {
                AutomatedMovement.this.projection.setNewOrigin(placeIncrement);
                AutomatedMovement.this.worker.workRequest();
                try {
                    Thread.sleep((long)timeIncrement);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private abstract class Task {
        private Task() {
        }

        public abstract void doTask();

        public abstract void stop();
    }
}

