/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataviews.vertexes;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.dataview.MicroarrayGraph;
import fi.csc.microarray.client.dataviews.vertexes.AbstractGraphVertex;
import fi.csc.microarray.client.dataviews.vertexes.GroupVertex;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgraph.graph.GraphConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphVertex
extends AbstractGraphVertex {
    private static final Logger logger = Logger.getLogger(GraphVertex.class);
    private List<GraphVertex> children = new ArrayList<GraphVertex>();
    private String tooltipText;
    private MicroarrayGraph graph;

    public GraphVertex(int x, int y, DataBean data, MicroarrayGraph graph) {
        super(x, y, data, graph);
        Color c = data == null || data.getOperation() == null || data.getOperation().getCategoryColor() == null ? DEFAULT_VERTEX_COLOR : data.getOperation().getCategoryColor();
        GraphConstants.setGradientColor(this.getAttributes(), c);
        GraphConstants.setBackground(this.getAttributes(), c.brighter());
        GraphConstants.setOpaque(this.getAttributes(), true);
        GraphConstants.setBorder(this.getAttributes(), BORDER_NORMAL);
        this.addPort();
        this.graph = graph;
        try {
            int rowCount = data.queryFeatures("/rowcount/max/1000").asFloat().intValue();
            this.tooltipText = rowCount < 1000 ? "" + rowCount + " rows" : "over " + rowCount + " rows";
        }
        catch (MicroarrayException e) {
            this.tooltipText = "";
        }
        graph.getGraphLayoutCache().toFront(new Object[]{this});
        graph.repaint();
    }

    public DataBean getData() {
        Object userObject = this.getUserObject();
        assert (userObject instanceof DataBean);
        return (DataBean)userObject;
    }

    public DataFolder getFolder() {
        return this.getData().getParent();
    }

    public GroupVertex getGroup() {
        if (this.getParent() instanceof GroupVertex) {
            return (GroupVertex)this.getParent();
        }
        return null;
    }

    public boolean isInGroup() {
        return this.getGroup() != null;
    }

    @Override
    public int getDefaultHeight() {
        return 20;
    }

    @Override
    public int getDefaultWidth() {
        return 40;
    }

    public int getMarginX() {
        return 10;
    }

    public int getMarginY() {
        return 30;
    }

    @Override
    public String getToolTipString() {
        return this.getData().toString() + ", " + this.tooltipText;
    }

    @Override
    public String toString() {
        Operation oper = this.getData().getOperation();
        String catName = oper.getCategoryName();
        if (catName.startsWith("Import")) {
            return "file";
        }
        return catName.substring(0, catName.length() > 4 ? 4 : catName.length());
    }

    @Override
    public void addChildVertex(GraphVertex child) {
        this.children.add(child);
    }

    @Override
    public boolean removeChildVertex(GraphVertex child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
            return true;
        }
        return false;
    }

    public List<GraphVertex> getChildVertices() {
        return this.children;
    }

    public List<GraphVertex> getRootVerticesOfThisVertex() {
        ArrayList<GraphVertex> roots = new ArrayList<GraphVertex>();
        this.findRoots(this.getData(), roots);
        return roots;
    }

    private void findRoots(DataBean data, List<GraphVertex> roots) {
        for (DataBean source : data.getLinkTargets(DataBean.Link.DERIVATION, DataBean.Link.MODIFICATION)) {
            if (source.getLinkTargets(DataBean.Link.DERIVATION, DataBean.Link.MODIFICATION).size() == 0) {
                GraphVertex vertex = this.graph.getVertexMap().get(source);
                if (roots.contains(vertex)) continue;
                roots.add(this.graph.getVertexMap().get(source));
                continue;
            }
            this.findRoots(source, roots);
        }
    }

    @Override
    public boolean isRoot() {
        logger.debug("vertex " + this.getData().getName() + " derives from " + this.getData().getLinkTargets(DataBean.Link.DERIVATION).size() + " databeans");
        return this.getData().getLinkTargets(DataBean.Link.derivationalTypes()).size() == 0;
    }
}

