/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.kaha.ContainerId;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.IndexRootContainer;
import org.apache.activemq.kaha.impl.StoreLockedExcpetion;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.DataManagerFacade;
import org.apache.activemq.kaha.impl.container.ListContainerImpl;
import org.apache.activemq.kaha.impl.container.MapContainerImpl;
import org.apache.activemq.kaha.impl.data.DataManagerImpl;
import org.apache.activemq.kaha.impl.data.RedoListener;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.activemq.kaha.impl.index.RedoStoreIndexItem;
import org.apache.activemq.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KahaStore
implements Store {
    private static final String PROPERTY_PREFIX = "org.apache.activemq.kaha.Store";
    private static final boolean BROKEN_FILE_LOCK = "true".equals(System.getProperty("org.apache.activemq.kaha.Store.FileLockBroken", "false"));
    private static final boolean DISABLE_LOCKING = "true".equals(System.getProperty("org.apache.activemq.kaha.Store.DisableLocking", "false"));
    private static final String LOCKSET_MONITOR = "org.apache.activemq.kaha.Store.Lock.Monitor";
    private static final Log LOG = LogFactory.getLog(KahaStore.class);
    private final File directory;
    private final String mode;
    private IndexRootContainer mapsContainer;
    private IndexRootContainer listsContainer;
    private Map<ContainerId, ListContainerImpl> lists = new ConcurrentHashMap<ContainerId, ListContainerImpl>();
    private Map<ContainerId, MapContainerImpl> maps = new ConcurrentHashMap<ContainerId, MapContainerImpl>();
    private Map<String, DataManager> dataManagers = new ConcurrentHashMap<String, DataManager>();
    private Map<String, IndexManager> indexManagers = new ConcurrentHashMap<String, IndexManager>();
    private IndexManager rootIndexManager;
    private boolean closed;
    private boolean initialized;
    private boolean logIndexChanges;
    private boolean useAsyncDataManager;
    private long maxDataFileLength = 0x2000000L;
    private FileLock lock;
    private boolean persistentIndex = true;
    private RandomAccessFile lockFile;
    private final AtomicLong storeSize;
    private String defaultContainerName = "kaha";

    public KahaStore(String name, String mode) throws IOException {
        this(new File(IOHelper.toFileSystemDirectorySafeName(name)), mode, new AtomicLong());
    }

    public KahaStore(File directory, String mode) throws IOException {
        this(directory, mode, new AtomicLong());
    }

    public KahaStore(String name, String mode, AtomicLong storeSize) throws IOException {
        this(new File(IOHelper.toFileSystemDirectorySafeName(name)), mode, storeSize);
    }

    public KahaStore(File directory, String mode, AtomicLong storeSize) throws IOException {
        this.mode = mode;
        this.storeSize = storeSize;
        this.directory = directory;
        this.directory.mkdirs();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.initialized) {
                this.unlock();
                for (ListContainerImpl listContainerImpl : this.lists.values()) {
                    listContainerImpl.close();
                }
                this.lists.clear();
                for (MapContainerImpl mapContainerImpl : this.maps.values()) {
                    mapContainerImpl.close();
                }
                this.maps.clear();
                Iterator<Object> iter = this.indexManagers.values().iterator();
                while (iter.hasNext()) {
                    IndexManager indexManager = iter.next();
                    indexManager.close();
                    iter.remove();
                }
                iter = this.dataManagers.values().iterator();
                while (iter.hasNext()) {
                    DataManager dataManager = (DataManager)iter.next();
                    dataManager.close();
                    iter.remove();
                }
            }
            if (this.lockFile != null) {
                this.lockFile.close();
                this.lockFile = null;
            }
        }
    }

    @Override
    public synchronized void force() throws IOException {
        if (this.initialized) {
            for (IndexManager im : this.indexManagers.values()) {
                im.force();
            }
            for (DataManager dm : this.dataManagers.values()) {
                dm.force();
            }
        }
    }

    @Override
    public synchronized void clear() throws IOException {
        Object container;
        this.initialize();
        for (ContainerId containerId : this.mapsContainer.getKeys()) {
            container = this.getMapContainer(containerId.getKey(), containerId.getDataContainerName());
            container.clear();
        }
        for (ContainerId containerId : this.listsContainer.getKeys()) {
            container = this.getListContainer(containerId.getKey(), containerId.getDataContainerName());
            container.clear();
        }
    }

    @Override
    public synchronized boolean delete() throws IOException {
        boolean result = true;
        if (this.initialized) {
            this.clear();
            Iterator<Object> iter = this.indexManagers.values().iterator();
            while (iter.hasNext()) {
                IndexManager im = iter.next();
                result &= im.delete();
                iter.remove();
            }
            iter = this.dataManagers.values().iterator();
            while (iter.hasNext()) {
                DataManager dm = (DataManager)iter.next();
                result &= dm.delete();
                iter.remove();
            }
        }
        if (this.directory != null && this.directory.isDirectory()) {
            result = IOHelper.deleteChildren(this.directory);
            String str = result ? "successfully deleted" : "failed to delete";
            LOG.info("Kaha Store " + str + " data directory " + this.directory);
        }
        return result;
    }

    @Override
    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean doesMapContainerExist(Object id) throws IOException {
        return this.doesMapContainerExist(id, this.defaultContainerName);
    }

    @Override
    public synchronized boolean doesMapContainerExist(Object id, String containerName) throws IOException {
        this.initialize();
        ContainerId containerId = new ContainerId();
        containerId.setKey(id);
        containerId.setDataContainerName(containerName);
        return this.maps.containsKey(containerId) || this.mapsContainer.doesRootExist(containerId);
    }

    @Override
    public MapContainer getMapContainer(Object id) throws IOException {
        return this.getMapContainer(id, this.defaultContainerName);
    }

    @Override
    public MapContainer getMapContainer(Object id, String containerName) throws IOException {
        return this.getMapContainer(id, containerName, this.persistentIndex);
    }

    @Override
    public synchronized MapContainer getMapContainer(Object id, String originalContainerName, boolean persistentIndex) throws IOException {
        this.initialize();
        String containerName = IOHelper.toFileSystemSafeName(originalContainerName);
        ContainerId containerId = new ContainerId();
        containerId.setKey(id);
        containerId.setDataContainerName(containerName);
        MapContainerImpl result = this.maps.get(containerId);
        if (result == null) {
            DataManager dm = this.getDataManager(containerName);
            IndexManager im = this.getIndexManager(dm, containerName);
            IndexItem root = this.mapsContainer.getRoot(im, containerId);
            if (root == null) {
                root = this.mapsContainer.addRoot(im, containerId);
            }
            result = new MapContainerImpl(this.directory, containerId, root, im, dm, persistentIndex);
            this.maps.put(containerId, result);
        }
        return result;
    }

    @Override
    public void deleteMapContainer(Object id) throws IOException {
        this.deleteMapContainer(id, this.defaultContainerName);
    }

    @Override
    public void deleteMapContainer(Object id, String containerName) throws IOException {
        ContainerId containerId = new ContainerId(id, containerName);
        this.deleteMapContainer(containerId);
    }

    @Override
    public synchronized void deleteMapContainer(ContainerId containerId) throws IOException {
        this.initialize();
        MapContainerImpl container = this.maps.remove(containerId);
        if (container != null) {
            container.clear();
            this.mapsContainer.removeRoot(container.getIndexManager(), containerId);
            container.close();
        }
    }

    @Override
    public synchronized Set<ContainerId> getMapContainerIds() throws IOException {
        this.initialize();
        HashSet<ContainerId> set = new HashSet<ContainerId>();
        for (ContainerId containerId : this.mapsContainer.getKeys()) {
            set.add(containerId);
        }
        return set;
    }

    @Override
    public boolean doesListContainerExist(Object id) throws IOException {
        return this.doesListContainerExist(id, this.defaultContainerName);
    }

    @Override
    public synchronized boolean doesListContainerExist(Object id, String containerName) throws IOException {
        this.initialize();
        ContainerId containerId = new ContainerId();
        containerId.setKey(id);
        containerId.setDataContainerName(containerName);
        return this.lists.containsKey(containerId) || this.listsContainer.doesRootExist(containerId);
    }

    @Override
    public ListContainer getListContainer(Object id) throws IOException {
        return this.getListContainer(id, this.defaultContainerName);
    }

    @Override
    public ListContainer getListContainer(Object id, String containerName) throws IOException {
        return this.getListContainer(id, containerName, this.persistentIndex);
    }

    @Override
    public synchronized ListContainer getListContainer(Object id, String originalContainerName, boolean persistentIndex) throws IOException {
        this.initialize();
        String containerName = IOHelper.toFileSystemSafeName(originalContainerName);
        ContainerId containerId = new ContainerId();
        containerId.setKey(id);
        containerId.setDataContainerName(containerName);
        ListContainerImpl result = this.lists.get(containerId);
        if (result == null) {
            DataManager dm = this.getDataManager(containerName);
            IndexManager im = this.getIndexManager(dm, containerName);
            IndexItem root = this.listsContainer.getRoot(im, containerId);
            if (root == null) {
                root = this.listsContainer.addRoot(im, containerId);
            }
            result = new ListContainerImpl(containerId, root, im, dm, persistentIndex);
            this.lists.put(containerId, result);
        }
        return result;
    }

    @Override
    public void deleteListContainer(Object id) throws IOException {
        this.deleteListContainer(id, this.defaultContainerName);
    }

    @Override
    public synchronized void deleteListContainer(Object id, String containerName) throws IOException {
        ContainerId containerId = new ContainerId(id, containerName);
        this.deleteListContainer(containerId);
    }

    @Override
    public synchronized void deleteListContainer(ContainerId containerId) throws IOException {
        this.initialize();
        ListContainerImpl container = this.lists.remove(containerId);
        if (container != null) {
            this.listsContainer.removeRoot(container.getIndexManager(), containerId);
            container.clear();
            container.close();
        }
    }

    @Override
    public synchronized Set<ContainerId> getListContainerIds() throws IOException {
        this.initialize();
        HashSet<ContainerId> set = new HashSet<ContainerId>();
        for (ContainerId containerId : this.listsContainer.getKeys()) {
            set.add(containerId);
        }
        return set;
    }

    public IndexRootContainer getListsContainer() {
        return this.listsContainer;
    }

    public IndexRootContainer getMapsContainer() {
        return this.mapsContainer;
    }

    public synchronized DataManager getDataManager(String name) throws IOException {
        DataManager dm = this.dataManagers.get(name);
        if (dm == null) {
            if (this.isUseAsyncDataManager()) {
                AsyncDataManager t = new AsyncDataManager(this.storeSize);
                t.setDirectory(this.directory);
                t.setFilePrefix("async-data-" + name + "-");
                t.setMaxFileLength((int)this.maxDataFileLength);
                t.start();
                dm = new DataManagerFacade(t, name);
            } else {
                DataManagerImpl t = new DataManagerImpl(this.directory, name, this.storeSize);
                t.setMaxFileLength(this.maxDataFileLength);
                dm = t;
            }
            if (this.logIndexChanges) {
                this.recover(dm);
            }
            this.dataManagers.put(name, dm);
        }
        return dm;
    }

    public synchronized IndexManager getIndexManager(DataManager dm, String name) throws IOException {
        IndexManager im = this.indexManagers.get(name);
        if (im == null) {
            im = new IndexManager(this.directory, name, this.mode, this.logIndexChanges ? dm : null, this.storeSize);
            this.indexManagers.put(name, im);
        }
        return im;
    }

    private void recover(final DataManager dm) throws IOException {
        dm.recoverRedoItems(new RedoListener(){

            public void onRedoItem(StoreLocation item, Object o) throws Exception {
                RedoStoreIndexItem redo = (RedoStoreIndexItem)o;
                IndexManager im = KahaStore.this.getIndexManager(dm, dm.getName());
                im.redo(redo);
            }
        });
    }

    public synchronized boolean isLogIndexChanges() {
        return this.logIndexChanges;
    }

    public synchronized void setLogIndexChanges(boolean logIndexChanges) {
        this.logIndexChanges = logIndexChanges;
    }

    @Override
    public synchronized long getMaxDataFileLength() {
        return this.maxDataFileLength;
    }

    @Override
    public synchronized void setMaxDataFileLength(long maxDataFileLength) {
        this.maxDataFileLength = maxDataFileLength;
    }

    public synchronized String getIndexTypeAsString() {
        return this.persistentIndex ? "PERSISTENT" : "VM";
    }

    public synchronized void setIndexTypeAsString(String type) {
        this.persistentIndex = !type.equalsIgnoreCase("VM");
    }

    @Override
    public boolean isPersistentIndex() {
        return this.persistentIndex;
    }

    @Override
    public void setPersistentIndex(boolean persistentIndex) {
        this.persistentIndex = persistentIndex;
    }

    public synchronized boolean isUseAsyncDataManager() {
        return this.useAsyncDataManager;
    }

    public synchronized void setUseAsyncDataManager(boolean useAsyncWriter) {
        this.useAsyncDataManager = useAsyncWriter;
    }

    @Override
    public long size() {
        return this.storeSize.get();
    }

    @Override
    public String getDefaultContainerName() {
        return this.defaultContainerName;
    }

    @Override
    public void setDefaultContainerName(String defaultContainerName) {
        this.defaultContainerName = defaultContainerName;
    }

    @Override
    public synchronized void initialize() throws IOException {
        if (this.closed) {
            throw new IOException("Store has been closed.");
        }
        if (!this.initialized) {
            LOG.info("Kaha Store using data directory " + this.directory);
            this.lockFile = new RandomAccessFile(new File(this.directory, "lock"), "rw");
            this.lock();
            DataManager defaultDM = this.getDataManager(this.defaultContainerName);
            this.rootIndexManager = this.getIndexManager(defaultDM, this.defaultContainerName);
            IndexItem mapRoot = new IndexItem();
            IndexItem listRoot = new IndexItem();
            if (this.rootIndexManager.isEmpty()) {
                mapRoot.setOffset(0L);
                this.rootIndexManager.storeIndex(mapRoot);
                listRoot.setOffset(51L);
                this.rootIndexManager.storeIndex(listRoot);
                this.rootIndexManager.setLength(102L);
            } else {
                mapRoot = this.rootIndexManager.getIndex(0L);
                listRoot = this.rootIndexManager.getIndex(51L);
            }
            this.initialized = true;
            this.mapsContainer = new IndexRootContainer(mapRoot, this.rootIndexManager, defaultDM);
            this.listsContainer = new IndexRootContainer(listRoot, this.rootIndexManager, defaultDM);
            this.generateInterestInMapDataFiles();
            this.generateInterestInListDataFiles();
            for (DataManager dm : this.dataManagers.values()) {
                dm.consolidateDataFiles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock() throws IOException {
        String string = LOCKSET_MONITOR;
        synchronized (LOCKSET_MONITOR) {
            if (!DISABLE_LOCKING && this.directory != null && this.lock == null) {
                String key = this.getPropertyKey();
                String property = System.getProperty(key);
                if (null == property) {
                    if (!BROKEN_FILE_LOCK) {
                        this.lock = this.lockFile.getChannel().tryLock();
                        if (this.lock == null) {
                            throw new StoreLockedExcpetion("Kaha Store " + this.directory.getName() + "  is already opened by another application");
                        }
                        System.setProperty(key, new Date().toString());
                    }
                } else {
                    throw new StoreLockedExcpetion("Kaha Store " + this.directory.getName() + " is already opened by this application.");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() throws IOException {
        String string = LOCKSET_MONITOR;
        synchronized (LOCKSET_MONITOR) {
            if (!DISABLE_LOCKING && null != this.directory && null != this.lock) {
                System.getProperties().remove(this.getPropertyKey());
                if (this.lock.isValid()) {
                    this.lock.release();
                }
                this.lock = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private String getPropertyKey() throws IOException {
        return this.getClass().getName() + ".lock." + this.directory.getCanonicalPath();
    }

    private void generateInterestInListDataFiles() throws IOException {
        for (ContainerId containerId : this.listsContainer.getKeys()) {
            DataManager dm = this.getDataManager(containerId.getDataContainerName());
            IndexManager im = this.getIndexManager(dm, containerId.getDataContainerName());
            IndexItem theRoot = this.listsContainer.getRoot(im, containerId);
            long nextItem = theRoot.getNextItem();
            while (nextItem != -1L) {
                IndexItem item = im.getIndex(nextItem);
                item.setOffset(nextItem);
                dm.addInterestInFile(item.getKeyFile());
                dm.addInterestInFile(item.getValueFile());
                nextItem = item.getNextItem();
            }
        }
    }

    private void generateInterestInMapDataFiles() throws IOException {
        for (ContainerId containerId : this.mapsContainer.getKeys()) {
            DataManager dm = this.getDataManager(containerId.getDataContainerName());
            IndexManager im = this.getIndexManager(dm, containerId.getDataContainerName());
            IndexItem theRoot = this.mapsContainer.getRoot(im, containerId);
            long nextItem = theRoot.getNextItem();
            while (nextItem != -1L) {
                IndexItem item = im.getIndex(nextItem);
                item.setOffset(nextItem);
                dm.addInterestInFile(item.getKeyFile());
                dm.addInterestInFile(item.getValueFile());
                nextItem = item.getNextItem();
            }
        }
    }
}

