/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.console.command.QueryCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BstatCommand
extends QueryCommand {
    protected String[] helpFile = new String[]{"Task Usage: activemq-admin bstat [bstat-options] [broker-name]", "Description: Performs a predefined query that displays useful statistics regarding the specified broker.", "             If no broker name is specified, it will try and select from all registered brokers.", "", "Bstat Options:", "    --jmxurl <url>                Set the JMX URL to connect to.", "    --version                     Display the version information.", "    -h,-?,--help                  Display the query broker help information.", "", "Examples:", "    activemq-admin bstat localhost", "        - Display a summary of statistics for the broker 'localhost'"};

    @Override
    protected void runTask(List<String> tokens) throws Exception {
        ArrayList<String> queryTokens = new ArrayList<String>();
        String brokerName = "*";
        for (String token : tokens) {
            if (!token.startsWith("-")) {
                brokerName = token;
                break;
            }
            queryTokens.add(token);
        }
        queryTokens.add("--objname");
        queryTokens.add("Type=*,BrokerName=" + brokerName);
        queryTokens.add("-xQTopic=ActiveMQ.Advisory.*");
        queryTokens.add("--vuew");
        queryTokens.add("Type,BrokerName,Destination,ConnectorName,EnqueueCount,DequeueCount,TotalEnqueueCount,TotalDequeueCount,Messages,TotalMessages,ConsumerCount,TotalConsumerCount,DispatchQueueSize");
        super.runTask(queryTokens);
    }
}

