/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;

public class JmsTempDestinationTest
extends TestCase {
    private Connection connection;
    private ActiveMQConnectionFactory factory;
    protected List<Connection> connections = Collections.synchronizedList(new ArrayList());

    protected void setUp() throws Exception {
        this.factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.factory.setAlwaysSyncSend(true);
        this.connection = this.factory.createConnection();
        this.connections.add(this.connection);
    }

    protected void tearDown() throws Exception {
        Iterator<Connection> iter = this.connections.iterator();
        while (iter.hasNext()) {
            Connection conn = iter.next();
            try {
                conn.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            iter.remove();
        }
    }

    public void testTempDestOnlyConsumedByLocalConn() throws JMSException {
        this.connection.start();
        Session tempSession = this.connection.createSession(false, 1);
        TemporaryQueue queue = tempSession.createTemporaryQueue();
        MessageProducer producer = tempSession.createProducer(queue);
        producer.setDeliveryMode(1);
        TextMessage message = tempSession.createTextMessage("First");
        producer.send(message);
        Connection otherConnection = this.factory.createConnection();
        this.connections.add(otherConnection);
        Session otherSession = otherConnection.createSession(false, 1);
        TemporaryQueue otherQueue = otherSession.createTemporaryQueue();
        MessageConsumer consumer = otherSession.createConsumer(otherQueue);
        Message msg = consumer.receive(3000L);
        JmsTempDestinationTest.assertNull((Object)msg);
        try {
            consumer = otherSession.createConsumer(queue);
            JmsTempDestinationTest.fail((String)"Send should fail since temp destination should be used from another connection");
        }
        catch (InvalidDestinationException e) {
            JmsTempDestinationTest.assertTrue((String)"failed to throw an exception", (boolean)true);
        }
        consumer = tempSession.createConsumer(queue);
        msg = consumer.receive(3000L);
        JmsTempDestinationTest.assertNotNull((Object)msg);
    }

    public void testTempQueueHoldsMessagesWithConsumers() throws JMSException {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer(queue);
        this.connection.start();
        MessageProducer producer = session.createProducer(queue);
        producer.setDeliveryMode(1);
        TextMessage message = session.createTextMessage("Hello");
        producer.send(message);
        Message message2 = consumer.receive(1000L);
        JmsTempDestinationTest.assertNotNull((Object)message2);
        JmsTempDestinationTest.assertTrue((String)"Expected message to be a TextMessage", (boolean)(message2 instanceof TextMessage));
        JmsTempDestinationTest.assertTrue((String)("Expected message to be a '" + message.getText() + "'"), (boolean)((TextMessage)message2).getText().equals(message.getText()));
    }

    public void testTempQueueHoldsMessagesWithoutConsumers() throws JMSException {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        MessageProducer producer = session.createProducer(queue);
        producer.setDeliveryMode(1);
        TextMessage message = session.createTextMessage("Hello");
        producer.send(message);
        this.connection.start();
        MessageConsumer consumer = session.createConsumer(queue);
        Message message2 = consumer.receive(3000L);
        JmsTempDestinationTest.assertNotNull((Object)message2);
        JmsTempDestinationTest.assertTrue((String)"Expected message to be a TextMessage", (boolean)(message2 instanceof TextMessage));
        JmsTempDestinationTest.assertTrue((String)("Expected message to be a '" + message.getText() + "'"), (boolean)((TextMessage)message2).getText().equals(message.getText()));
    }

    public void testTmpQueueWorksUnderLoad() throws JMSException {
        int count = 500;
        int dataSize = 1024;
        ArrayList<BytesMessage> list = new ArrayList<BytesMessage>(count);
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        MessageProducer producer = session.createProducer(queue);
        producer.setDeliveryMode(1);
        byte[] data = new byte[dataSize];
        for (int i = 0; i < count; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(data);
            message.setIntProperty("c", i);
            producer.send(message);
            list.add(message);
        }
        this.connection.start();
        MessageConsumer consumer = session.createConsumer(queue);
        for (int i = 0; i < count; ++i) {
            Message message2 = consumer.receive(2000L);
            JmsTempDestinationTest.assertTrue((message2 != null ? 1 : 0) != 0);
            JmsTempDestinationTest.assertEquals((int)i, (int)message2.getIntProperty("c"));
            JmsTempDestinationTest.assertTrue((boolean)message2.equals(list.get(i)));
        }
    }

    public void testPublishFailsForClosedConnection() throws JMSException, InterruptedException, URISyntaxException {
        Connection tempConnection = this.factory.createConnection();
        this.connections.add(tempConnection);
        Session tempSession = tempConnection.createSession(false, 1);
        TemporaryQueue queue = tempSession.createTemporaryQueue();
        Session session = this.connection.createSession(false, 1);
        this.connection.start();
        MessageProducer producer = session.createProducer(queue);
        producer.setDeliveryMode(1);
        TextMessage message = session.createTextMessage("First");
        producer.send(message);
        tempConnection.close();
        Thread.sleep(5000L);
        try {
            message = session.createTextMessage("Hello");
            producer.send(message);
            JmsTempDestinationTest.fail((String)"Send should fail since temp destination should not exist anymore.");
        }
        catch (JMSException e) {
            // empty catch block
        }
    }

    public void testPublishFailsForDestoryedTempDestination() throws JMSException, InterruptedException {
        Connection tempConnection = this.factory.createConnection();
        this.connections.add(tempConnection);
        Session tempSession = tempConnection.createSession(false, 1);
        TemporaryQueue queue = tempSession.createTemporaryQueue();
        Session session = this.connection.createSession(false, 1);
        this.connection.start();
        MessageProducer producer = session.createProducer(queue);
        producer.setDeliveryMode(1);
        TextMessage message = session.createTextMessage("First");
        producer.send(message);
        queue.delete();
        Thread.sleep(5000L);
        try {
            message = session.createTextMessage("Hello");
            producer.send(message);
            JmsTempDestinationTest.fail((String)"Send should fail since temp destination should not exist anymore.");
        }
        catch (JMSException e) {
            JmsTempDestinationTest.assertTrue((String)"failed to throw an exception", (boolean)true);
        }
    }

    public void testDeleteDestinationWithSubscribersFails() throws JMSException {
        Connection connection = this.factory.createConnection();
        this.connections.add(connection);
        Session session = connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        connection.start();
        session.createConsumer(queue);
        try {
            queue.delete();
            JmsTempDestinationTest.fail((String)"Should fail as Subscribers are active");
        }
        catch (JMSException e) {
            JmsTempDestinationTest.assertTrue((String)"failed to throw an exception", (boolean)true);
        }
    }
}

