/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.activemq.ActiveMQConnectionFactory;

public class JmsRedeliveredTest
extends TestCase {
    private Connection connection;

    protected void setUp() throws Exception {
        this.connection = this.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    protected Connection createConnection() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        return factory.createConnection();
    }

    public void testQueueSessionCloseMarksMessageRedelivered() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        MessageProducer producer = this.createProducer(session, queue);
        producer.send(this.createTextMessage(session));
        MessageConsumer consumer = session.createConsumer(queue);
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer(queue);
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        msg.acknowledge();
        session.close();
    }

    public void testQueueRecoverMarksMessageRedelivered() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        MessageProducer producer = this.createProducer(session, queue);
        producer.send(this.createTextMessage(session));
        MessageConsumer consumer = session.createConsumer(queue);
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.recover();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        msg.acknowledge();
        session.close();
    }

    public void testQueueRollbackMarksMessageRedelivered() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        MessageProducer producer = this.createProducer(session, queue);
        producer.send(this.createTextMessage(session));
        session.commit();
        MessageConsumer consumer = session.createConsumer(queue);
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.rollback();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        session.commit();
        session.close();
    }

    public void testDurableTopicSessionCloseMarksMessageRedelivered() throws JMSException {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "sub1");
        MessageProducer producer = session.createProducer(topic);
        producer.setDeliveryMode(2);
        producer.send(this.createTextMessage(session));
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be re-delivered.", (boolean)msg.getJMSRedelivered());
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createDurableSubscriber(topic, "sub1");
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        msg.acknowledge();
        session.close();
    }

    public void testDurableTopicRecoverMarksMessageRedelivered() throws JMSException {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "sub1");
        MessageProducer producer = this.createProducer(session, topic);
        producer.send(this.createTextMessage(session));
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.recover();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        msg.acknowledge();
        session.close();
    }

    public void testDurableTopicRollbackMarksMessageRedelivered() throws JMSException {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "sub1");
        MessageProducer producer = this.createProducer(session, topic);
        producer.send(this.createTextMessage(session));
        session.commit();
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.rollback();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        session.commit();
        session.close();
    }

    public void testTopicRecoverMarksMessageRedelivered() throws JMSException {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        MessageConsumer consumer = session.createConsumer(topic);
        MessageProducer producer = this.createProducer(session, topic);
        producer.send(this.createTextMessage(session));
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.recover();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        msg.acknowledge();
        session.close();
    }

    public void testTopicRollbackMarksMessageRedelivered() throws JMSException {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        MessageConsumer consumer = session.createConsumer(topic);
        MessageProducer producer = this.createProducer(session, topic);
        producer.send(this.createTextMessage(session));
        session.commit();
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.rollback();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        session.commit();
        session.close();
    }

    private TextMessage createTextMessage(Session session) throws JMSException {
        return session.createTextMessage("Hello");
    }

    private MessageProducer createProducer(Session session, Destination queue) throws JMSException {
        MessageProducer producer = session.createProducer(queue);
        producer.setDeliveryMode(this.getDeliveryMode());
        return producer;
    }

    protected int getDeliveryMode() {
        return 2;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(PersistentCase.class);
        suite.addTestSuite(TransientCase.class);
        return suite;
    }

    public static final class TransientCase
    extends JmsRedeliveredTest {
        protected int getDeliveryMode() {
            return 1;
        }
    }

    public static final class PersistentCase
    extends JmsRedeliveredTest {
        protected int getDeliveryMode() {
            return 2;
        }
    }
}

