/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.TestSupport;

public class ConsumerReceiveWithTimeoutTest
extends TestSupport {
    private Connection connection;

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    public void testConsumerReceiveBeforeMessageDispatched() throws JMSException {
        this.connection.start();
        final Session session = this.connection.createSession(false, 1);
        final Queue queue = session.createQueue("test");
        Thread t = new Thread(){

            public void run() {
                try {
                    Thread.sleep(10000L);
                    MessageProducer producer = session.createProducer(queue);
                    producer.send(session.createTextMessage("Hello"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        MessageConsumer consumer = session.createConsumer(queue);
        Message msg = consumer.receive(60000L);
        ConsumerReceiveWithTimeoutTest.assertNotNull((Object)msg);
        session.close();
    }
}

