# ANALYSIS Utilities/"Import from GEO" (Imports a SOFT-formatted datafile directly from GEO. 
# Be sure to specify the chiptype as an Affymetrix chip name, or either Illumina or cDNA.)
# OUTPUT normalized.tsv, phenodata.tsv 
# PARAMETER GDS.name STRING DEFAULT empty (GDS number of the experiment.)
# PARAMETER chiptype STRING DEFAULT empty (Chiptype)


# JTT 9.8.2007

# Loads the libraries
library(GEOquery)

# Loads and parses the SOFT file
if(GDS.name!="empty") {
   gds<-getGEO(GDS.name)
   eset<-GDS2eSet(gds, do.log2=T)
   dat<-exprs(eset)
   colnames(dat)<-paste("chip.", colnames(dat), sep="")
}

if(GDS.name=="empty") {
   stop("You need to specify a valid GDS!")
}

# Writes out a phenodata
sample<-colnames(eset@exprs)
group<-c(rep("", nrow(pData(eset))))
training<-c(rep("", nrow(pData(eset))))
time<-c(rep("", nrow(pData(eset))))
random<-c(rep("", nrow(pData(eset))))
write.table(data.frame(sample=sample, group=group, training=training, chiptype=chiptype), file="phenodata.tsv", sep="\t", row.names=F, col.names=T, quote=F)

# Writes out a normalized datafile
write.table(as.data.frame(dat), file="normalized.tsv", col.names=T, quote=F, sep="\t", row.names=T)
