# ANALYSIS Normalisation/"Illumina" (Illumina normalization using BeadSummaryData files.)
# INPUT CDNA chip[...].tsv OUTPUT normalized.tsv, phenodata.tsv
# PARAMETER transformation [none, vst, log2] DEFAULT log2 (How to transform the data)
# PARAMETER normalize.genes [none, rsn, loess, quantile, vsn] DEFAULT quantile (Between arrays normalization method)
# PARAMETER chiptype [empty, Human-6v1, HumanRef-8v1, Human-6v2, HumanRef-8v2, Mouse-6v1.0a, MouseRef-8v1.0a, Mouse-6v1.1, MouseRef-8v1.1, RatRef-12] DEFAULT empty (chiptype)


# Illumina data preprocessing and normalization for BeadSummaryData
# JTT 27.5.2008

# Loading libraries
library(lumi)

# Converting to the correct chiptype
   if(chiptype=="empty") {
      chiptype<-c("Illumina")
   }
   if(chiptype=="Human-6v1" | chiptype=="HumanRef-8v1") {
      chiptype<-c("lumiHumanV1")
   }
   if(chiptype=="Human-6v2" | chiptype=="HumanRef-8v2") {
      chiptype<-c("lumiHumanV2")
   }
   if(chiptype=="Mouse-6v1.0a" | chiptype=="MouseRef-8v1.0a") {
      chiptype<-c("lumiMouseV1")
   }
   if(chiptype=="RatRef-12") {
      chiptype<-c("lumiRatV1")
   }

# Loading data files
fileName <- c("ProbeProfile.txt")
x.lumi <- lumiR(fileName, lib="lumiHumanV2")

# Quality control (not run)
# QC
# q.lumi <- lumiQ(x.lumi)  

# Transformation
if(transformation=="none") {
   t.lumi<-x.lumi
}
if(transformation=="vst") {
   t.lumi<-lumiT(x.lumi, method=c("vst"))
}
if(transformation=="log2") {
   t.lumi<-lumiT(x.lumi, method=c("vst"))
}

# Normalization
if(normalize.genes=="none") {
   n.lumi<-t.lumi
}
if(normalize.genes=="rsn") {
   n.lumi<-lumiN(t.lumi, method=c("rsn"))
}
if(normalize.genes=="loess") {
   n.lumi<-lumiN(t.lumi, method=c("loess"))
}
if(normalize.genes=="quantile") {
   n.lumi<-lumiN(t.lumi, method=c("quantile"))
}
if(normalize.genes=="vsn") {
   n.lumi<-lumiN(t.lumi, method=c("vsn"))
}

# Write out a phenodata
write.table(data.frame(sample=sample.names, chiptype=chiptype, group=group, training=training), file="phenodata.tsv", sep="\t", row.names=F, col.names=T, quote=F)

# Write out expression data
dat2<-exprs(n.lumi)
write.table(data.frame(dat2), file="normalized.tsv", col.names=T, quote=F, sep="\t", row.names=T)