/* ======================================================================= 
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 *
 */

package org.jfree.chart.plot;

import java.util.List;

import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.AbstractHCClusteringInfo;

/**
 * A mediator class to adapt CategoryAxis to {@link HCPlot}.
 * The problem is that HCPlot needs CategoryAxis-object for both
 * horizontal and vertical axises with different sets of categories.
 * However, CategoryAxis only allows single set of categories
 * to be used per plot, and it is not easy to inherit a subclass
 * implementing the usage of multiple categories. This mediates the two
 * classes so that they work nicely together.
 *
 * @author  viski project
 */
public class HCMediator extends CategoryPlot {

    AbstractHCClusteringInfo clusteringInfo;

    /**
     * Creates a new HCMediator corresponding to given clustering info
     * object.
     */
    public HCMediator(AbstractHCClusteringInfo clusteringInfo) {

	this.clusteringInfo = clusteringInfo;

    }

    /**
     * Returns the categories as a list.
     * This is the method CategoryAxis needs.
     *
     * @return  the categories as a list.
     */
    public List getCategories() {

	return this.clusteringInfo.getNames();

    }

}
