/* =======================================================================
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 *
 */

package org.jfree.chart.plot;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Arrays;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jfree.data.hc.HCTreeNode;
import org.jfree.data.hc.DataRange;
import org.jfree.chart.plot.AbstractHCClusteringInfo;

/**
 * A class that stores information about the state of a clustering tree.
 * used in {@link HCPlot}. This is organized as a tree with the same topology
 * as the original clustering tree.
 *
 * @author  viski project
 */
public class DummyHCClusteringInfo extends AbstractHCClusteringInfo {

    /**
     * Creates a new DummyHCClusteringInfo for non-clustered datasets 
     *
     * @param names  names of rows or columns.
     * @param location  column or leaf tree?
     */
    public DummyHCClusteringInfo(String[] names, int location) {

	if ((location != HCPlot.LEFT) && (location != HCPlot.TOP))
	    throw new IllegalArgumentException(
		    "location must be LEFT or RIGHT.");

	if (names == null) throw new NullPointerException(
	    "Names of a DummyHCClusteringInfo cannot be null.");
        this.location=location;
	this.names = names;
	this.listeners = new LinkedList();

    }

    /**
     * Returns the visible data range. i.e. number of rows/columns
     * of a heatmap currently seen on the screen.
     *
     * @return  The datarange specifying the visible indices.
     */
    public int getNumberOfVisibleItems() {

	return this.names.length;

    }

    /**
     * Return the names of visible rows/columns corresponding to
     * this clustering info object.
     *
     * @return  a list object containing the names.
     */
    public HCTreeNodeInfo getRootNode() {

	return null;

    }

    /**
     * Return the HCTreeNodeInfo corresponding to the root node
     * of the clustering tree.
     *
     * @return  the root node, or null, if the clustering tree does not exist.
     */
    public List getNames() {

	return Arrays.asList(names);

    }

    /**
     * Returns the indices of the dataset that
     * correspond to specified visible index
     *
     * @param row  the row.
     * @return  The datarange specifying the rows.
     */
    public DataRange getDataRangeForVisibleIndex(int row) {

	return new DataRange(row,row);
    }


}
