/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.wizard.affymetrix;

import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.wizard.WizardPlugin;
import fi.csc.microarray.wizard.affymetrix.FileGroup;
import fi.csc.microarray.wizard.affymetrix.FileGroupPanelDesc;
import fi.csc.microarray.wizard.affymetrix.SelectionItem;
import fi.csc.microarray.wizard.affymetrix.SelectionSet;
import fi.csc.microarray.wizard.affymetrix.TitlePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileGroupPanel
extends TitlePanel {
    private JTextArea fileList = new JTextArea(7, 30);
    private JComboBox groupList = new JComboBox();
    private SelectionSet selectionSet = new SelectionSet();
    private Map<String, FileGroup> groups = new HashMap<String, FileGroup>();
    private String groupname = null;
    private JTextArea infoArea = new JTextArea(5, 35);
    private FileGroupPanelDesc desc;

    public FileGroupPanel(FileGroupPanelDesc d) {
        this.desc = d;
        this.setTitle("Wizard: Load data files");
        JPanel contentPanel = this.getContentPanel();
        this.addContent(contentPanel);
    }

    private JPanel getContentPanel() {
        this.selectionSet.add("Group1", WizardPlugin.FILEGROUP_PREFIX + "1");
        this.selectionSet.add("Group2", WizardPlugin.FILEGROUP_PREFIX + "2");
        this.selectionSet.add("Group3", WizardPlugin.FILEGROUP_PREFIX + "3");
        this.selectionSet.add("Group4", WizardPlugin.FILEGROUP_PREFIX + "4");
        this.selectionSet.add("Group5", WizardPlugin.FILEGROUP_PREFIX + "5");
        this.selectionSet.initComboBox(this.groupList);
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BorderLayout());
        cPanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        JPanel groupPanel = new JPanel();
        groupPanel.setBorder(new EtchedBorder());
        groupPanel.setLayout(new BoxLayout(groupPanel, 1));
        cPanel.add((Component)groupPanel, "North");
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new FlowLayout(0));
        upperPanel.add(new JLabel("Select group:"));
        upperPanel.add(this.groupList);
        this.groupList.addActionListener(new GroupSelector());
        JScrollPane scrollPane = new JScrollPane(this.fileList, 20, 31);
        this.fileList.setEditable(false);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new FlowLayout(0));
        middlePanel.add(scrollPane);
        groupPanel.add(upperPanel);
        groupPanel.add(middlePanel);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new FlowLayout(0));
        groupPanel.add(lowerPanel);
        JButton addButton = new JButton("Add Files");
        addButton.addActionListener(new FileAdder());
        JButton resetButton = new JButton("Reset group");
        resetButton.addActionListener(new GroupReset());
        lowerPanel.add(addButton);
        lowerPanel.add(resetButton);
        JPanel infoPane = new JPanel();
        infoPane.setLayout(new BoxLayout(infoPane, 1));
        JPanel flowPane4 = new JPanel();
        flowPane4.setLayout(new FlowLayout(0));
        infoPane.add(flowPane4);
        this.infoArea.setEditable(false);
        this.infoArea.setFont(new Font("Verdana", 1, 10));
        this.infoArea.setBackground(VisualConstants.TEXTAREA_UNEDITABLE_BACKGROUND);
        flowPane4.add(this.infoArea);
        cPanel.add((Component)infoPane, "Center");
        JPanel textPanel = new JPanel();
        cPanel.add((Component)textPanel, "South");
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.add(new JLabel("Specify your experimental design by importing the chips as one or more"));
        textPanel.add(new JLabel("groups. A group can denote a treatment, or some other sample status that is"));
        textPanel.add(new JLabel("of interest. For example, if your experiment consists of healthy controls"));
        textPanel.add(new JLabel("and cancer patients, you should import controls as a group 1, and patients"));
        textPanel.add(new JLabel("as group 2. You can specify a maximum of 5 groups."));
        this.groupname = "filegroup1";
        this.infoArea.setText(this.getInfoString());
        return cPanel;
    }

    public Vector<FileGroup> getGroups() {
        Vector<FileGroup> groupSet = new Vector<FileGroup>();
        Iterator iter = this.selectionSet.getIterator();
        while (iter.hasNext()) {
            SelectionItem item = (SelectionItem)iter.next();
            String name = item.getInternalValue();
            FileGroup group = this.groups.get(name);
            if (group == null || group.getNum() <= 0) continue;
            groupSet.add(group);
        }
        return groupSet;
    }

    public boolean isGroupsEmpty() {
        Iterator iter = this.selectionSet.getIterator();
        boolean empty = true;
        while (iter.hasNext()) {
            SelectionItem item = (SelectionItem)iter.next();
            String name = item.getInternalValue();
            FileGroup group = this.groups.get(name);
            if (group == null || group.getNum() <= 0) continue;
            empty = false;
        }
        return empty;
    }

    private String getInfoString() {
        Iterator iter = this.selectionSet.getIterator();
        String text = null;
        String aux = null;
        while (iter.hasNext()) {
            SelectionItem item = (SelectionItem)iter.next();
            String publicName = item.getPublicValue();
            String internalName = item.getInternalValue();
            FileGroup group = this.groups.get(internalName);
            if (group != null && group.getNum() > 0) {
                aux = publicName + ": " + group.getNum() + " files";
            }
            if (aux != null) {
                text = text != null ? text + "\n" + aux : aux;
            }
            aux = null;
        }
        if (text == null) {
            text = new String(" ");
        }
        return text;
    }

    private class GroupReset
    implements ActionListener {
        private GroupReset() {
        }

        public void actionPerformed(ActionEvent e) {
            FileGroup group = null;
            group = (FileGroup)FileGroupPanel.this.groups.get(FileGroupPanel.this.groupname);
            if (group != null) {
                group.clear();
            }
            FileGroupPanel.this.fileList.setText("");
            FileGroupPanel.this.infoArea.setText(FileGroupPanel.this.getInfoString());
            FileGroupPanel.this.desc.setNextButton();
        }
    }

    private class FileAdder
    implements ActionListener {
        private FileAdder() {
        }

        public void actionPerformed(ActionEvent e) {
            FileGroup group = null;
            String text = null;
            JFileChooser fc = ImportUtils.getFixedFileChooser();
            fc.setMultiSelectionEnabled(true);
            int returnVal = fc.showOpenDialog(null);
            if (returnVal == 0) {
                File[] files = fc.getSelectedFiles();
                group = (FileGroup)FileGroupPanel.this.groups.get(FileGroupPanel.this.groupname);
                if (group == null) {
                    group = new FileGroup(FileGroupPanel.this.groupname);
                    FileGroupPanel.this.groups.put(FileGroupPanel.this.groupname, group);
                }
                for (File file : files) {
                    group.addFile(file);
                }
                text = group.getFileNameList();
                FileGroupPanel.this.fileList.setText(text);
                FileGroupPanel.this.infoArea.setText(FileGroupPanel.this.getInfoString());
                FileGroupPanel.this.desc.setNextButton();
            }
        }
    }

    private class GroupSelector
    implements ActionListener {
        private GroupSelector() {
        }

        public void actionPerformed(ActionEvent e) {
            String text = null;
            FileGroup group = null;
            Object obj = FileGroupPanel.this.groupList.getSelectedItem();
            FileGroupPanel.this.groupname = FileGroupPanel.this.selectionSet.getInternalValue(obj.toString());
            group = (FileGroup)FileGroupPanel.this.groups.get(FileGroupPanel.this.groupname);
            if (group != null) {
                text = group.getFileNameList();
            }
            FileGroupPanel.this.fileList.setText(text);
        }
    }
}

