/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import org.mortbay.util.IO;
import org.testng.Assert;

public class FileServerTest {
    private String repositoryUrl;
    private String testfile;
    boolean put = true;
    boolean get = true;

    public static void main(String[] args) throws Exception {
        new FileServerTest("http://nami.csc.fi:8080/fileserver", "/home/hupponen/workspace/chipster/examples/kidney4-affy.cel", 5, 1, true, true);
    }

    public FileServerTest(String repositoryUrl, String testfile, int threadCount, int repeatCount, boolean put, boolean get) {
        System.out.println("Rest test with repository: " + repositoryUrl + ", threads: " + threadCount + ", repeats: " + repeatCount);
        this.repositoryUrl = repositoryUrl;
        this.testfile = testfile;
        if (!put && !get) {
            this.put = true;
            this.get = true;
        } else {
            this.put = put;
            this.get = get;
        }
        for (int i = 0; i < threadCount; ++i) {
            new Thread(new PutGetTest(repeatCount)).start();
        }
    }

    public void test() throws Exception {
        byte[] fileContents = new byte[]{97, 98, 99};
        URL url = new URL("http://nami.csc.fi:8080/fileserver/file.txt");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        connection.setChunkedStreamingMode(fileContents.length);
        OutputStream os = connection.getOutputStream();
        IO.copy(new ByteArrayInputStream(fileContents), os);
        os.close();
        Assert.assertTrue(this.isSuccessfulCode(connection.getResponseCode()));
        connection.disconnect();
        connection = (HttpURLConnection)url.openConnection();
        InputStream is = connection.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IO.copy(is, baos);
        is.close();
        Assert.assertTrue(this.isSuccessfulCode(connection.getResponseCode()));
        connection.disconnect();
        Assert.assertEquals(fileContents.length, baos.size());
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        is = connection.getInputStream();
        is.close();
        Assert.assertTrue(this.isSuccessfulCode(connection.getResponseCode()));
    }

    private boolean isSuccessfulCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    class PutGetTest
    implements Runnable {
        private int repeatCount;

        public PutGetTest(int repeatCount) {
            this.repeatCount = repeatCount;
        }

        public void run() {
            String filename = "";
            boolean putOnce = false;
            if (FileServerTest.this.get && !FileServerTest.this.put) {
                filename = "testfile-" + UUID.randomUUID().toString();
                putOnce = true;
            }
            for (int i = 0; i < this.repeatCount; ++i) {
                try {
                    OutputStream os;
                    URL url = new URL(FileServerTest.this.repositoryUrl + "/" + filename);
                    HttpURLConnection connection = null;
                    if (putOnce) {
                        filename = "testfile-" + UUID.randomUUID().toString();
                        url = new URL(FileServerTest.this.repositoryUrl + "/" + filename);
                        connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("PUT");
                        connection.setDoOutput(true);
                        connection.setChunkedStreamingMode(2048);
                        os = connection.getOutputStream();
                        IO.copy(new FileInputStream(new File(FileServerTest.this.testfile)), os);
                        os.close();
                        Assert.assertTrue(FileServerTest.this.isSuccessfulCode(connection.getResponseCode()));
                        connection.disconnect();
                        putOnce = false;
                    }
                    if (FileServerTest.this.put) {
                        filename = "testfile-" + UUID.randomUUID().toString();
                        url = new URL(FileServerTest.this.repositoryUrl + "/" + filename);
                        connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("PUT");
                        connection.setDoOutput(true);
                        connection.setChunkedStreamingMode(2048);
                        os = connection.getOutputStream();
                        IO.copy(new FileInputStream(new File(FileServerTest.this.testfile)), os);
                        os.close();
                        Assert.assertTrue(FileServerTest.this.isSuccessfulCode(connection.getResponseCode()));
                        connection.disconnect();
                    }
                    if (!FileServerTest.this.get) continue;
                    connection = (HttpURLConnection)url.openConnection();
                    InputStream is = connection.getInputStream();
                    FileOutputStream fos = new FileOutputStream(new File(filename));
                    IO.copy(is, fos);
                    is.close();
                    ((OutputStream)fos).close();
                    Assert.assertTrue(FileServerTest.this.isSuccessfulCode(connection.getResponseCode()));
                    connection.disconnect();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

