/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.proto.repository;

import fi.csc.microarray.proto.repository.Repository;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query
implements Comparable<Query> {
    private static final String SUBQUERY_SEPARATOR = " AND ";
    private static final String STEP_SEPARATOR = "/";
    protected String query;
    protected Repository repository;

    public Query(String query, Repository repository) {
        this.query = query;
        this.repository = repository;
    }

    public boolean isValid() {
        try {
            if (this.hasSubQueries()) {
                for (Query subQuery : this.subQueries()) {
                    if (subQuery.isValid()) continue;
                    return false;
                }
            } else {
                for (String step : this.steps()) {
                    if (step.length() >= 1) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.query;
    }

    public Iterable<Query> subQueries() {
        LinkedList<Query> subQueries = new LinkedList<Query>();
        for (String subQuery : this.query.split(SUBQUERY_SEPARATOR)) {
            subQueries.add(new Query(subQuery.trim(), this.repository));
        }
        return subQueries;
    }

    public boolean hasSubQueries() {
        return this.query.contains(SUBQUERY_SEPARATOR);
    }

    public String getLastStep() {
        return this.query.substring(this.query.lastIndexOf(STEP_SEPARATOR) + 1).trim();
    }

    public String getSecondLastStep() {
        String[] steps = this.query.split(STEP_SEPARATOR);
        return steps[steps.length - 2];
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Iterable<String> steps() {
        assert (!this.hasSubQueries());
        LinkedList<String> steps = new LinkedList<String>();
        for (String subQuery : this.query.split(STEP_SEPARATOR)) {
            steps.add(subQuery.trim());
        }
        return steps;
    }

    public boolean equals(Object o) {
        return o instanceof Query && this.query.equals(((Query)o).toString());
    }

    @Override
    public int compareTo(Query q) {
        return this.query.compareTo(q.toString());
    }
}

