/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.biobeans;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class BioBean {
    private static final Logger logger = Logger.getLogger(BioBean.class);
    private static final String CDNA_SAMPLE_FG = "/column/sample";
    private static final String AFFY_INTENSITY = "/column/MEAN";
    public static final String PHENODATA_SAMPLE_COLUMN = "sample";
    public static final String PHENODATA_NAME_COLUMN = "original_name";
    private static final String PHENODATA_CHIPTYPE_COLUMN = "chiptype";
    private static final String PHENODATA_GROUP_COLUMN = "group";
    private DataBean dataBean;

    public static boolean isEditablePhenodataColumn(String columnName) {
        return !PHENODATA_SAMPLE_COLUMN.equals(columnName) && !PHENODATA_NAME_COLUMN.equals(columnName) && !PHENODATA_CHIPTYPE_COLUMN.equals(columnName);
    }

    public static boolean isGroupPhenodataColumn(String columnName) {
        return PHENODATA_GROUP_COLUMN.equals(columnName);
    }

    public BioBean(DataBean dataBean) {
        this.dataBean = dataBean;
    }

    public int getColorCount() {
        if (this.dataBean.fetchFeature(CDNA_SAMPLE_FG).exists()) {
            return 2;
        }
        if (this.dataBean.fetchFeature(AFFY_INTENSITY).exists()) {
            return 1;
        }
        return 0;
    }

    public VisualisationMethod getDefaultVisualisation() throws IOException, MicroarrayException {
        for (VisualisationMethod method : VisualisationMethod.orderedDefaultCandidates()) {
            if (method == VisualisationMethod.NONE || !method.isApplicableTo(this.dataBean)) continue;
            return method;
        }
        return null;
    }

    public DataBean getProperSource() {
        logger.debug(this.dataBean == null ? "databean is null" : "getting proper source of " + this.dataBean.getName() + ", source count is " + this.dataBean.getLinkTargets(DataBean.Link.DERIVATION).size());
        if (this.dataBean == null || this.dataBean.getLinkTargets(DataBean.Link.DERIVATION).size() == 0) {
            return null;
        }
        if (this.dataBean.getLinkTargets(DataBean.Link.DERIVATION).size() == 1) {
            return this.dataBean.getLinkTargets(DataBean.Link.DERIVATION).iterator().next();
        }
        LinkedList<DataBean> sourceCollector = new LinkedList<DataBean>();
        for (DataBean source : this.dataBean.getLinkTargets(DataBean.Link.DERIVATION)) {
            if (!source.fetchFeature("/phenodata").exists()) continue;
            sourceCollector.add(source);
        }
        if (sourceCollector.size() == 0 || sourceCollector.size() > 1) {
            return null;
        }
        return (DataBean)sourceCollector.getFirst();
    }

    public DataBean[] getSourcePath() {
        LinkedList<DataBean> list = new LinkedList<DataBean>();
        if (this.getProperSource() != null) {
            list.addAll(Arrays.asList(new BioBean(this.getProperSource()).getSourcePath()));
        }
        list.add(this.dataBean);
        return list.toArray(new DataBean[0]);
    }
}

