/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.features.RestrictModifier;
import fi.csc.microarray.databeans.features.bio.EmbeddedBinaryFactory;
import fi.csc.microarray.databeans.features.bio.NormalisedExpressionFactory;
import fi.csc.microarray.databeans.features.bio.PhenodataFactory;
import fi.csc.microarray.databeans.features.stat.HierarchicalClusterFactory;
import fi.csc.microarray.databeans.features.stat.LogModifier;
import fi.csc.microarray.databeans.features.stat.SomClusterFactory;
import fi.csc.microarray.databeans.features.table.TableColumnFactory;
import java.io.IOException;
import java.util.Properties;

public class ApplicationConstants {
    public static final String NAMI_VERSION;
    public static final String APPLICATION_TITLE;
    public static final String PHENODATA_DATASET_NAME = "phenodata.tsv";
    public static int MAX_JOBS;
    public static long MAX_JOB_SIZE;

    public static void plugFeatures(DataManager manager) {
        manager.plugFeatureFactory("/normalised-expression", new NormalisedExpressionFactory());
        manager.plugFeatureFactory("/phenodata", new PhenodataFactory());
        manager.plugFeatureFactory("/embedded-binary-content", new EmbeddedBinaryFactory());
        manager.plugFeatureFactory("/column", new TableColumnFactory());
        manager.plugFeatureFactory("/clusters/som", new SomClusterFactory());
        manager.plugFeatureFactory("/clusters/hierarchical", new HierarchicalClusterFactory());
        manager.plugModifier("log", new LogModifier());
        manager.plugModifier("restrict", new RestrictModifier());
        manager.plugContentType("image/png", true, true, "PNG image", VisualConstants.ICON_TYPE_IMAGE, "png");
        manager.plugContentType("image/gif", true, true, "GIF image", VisualConstants.ICON_TYPE_IMAGE, "gif");
        manager.plugContentType("image/jpeg", true, true, "JPEG image", VisualConstants.ICON_TYPE_IMAGE, "jpg", "jpeg");
        manager.plugContentType("text/html", true, false, "HTML document", VisualConstants.ICON_TYPE_HTML, "html", "htm");
        manager.plugContentType("text/tab", false, false, "tab separated values", VisualConstants.ICON_TYPE_TABLE, "tsv");
        manager.plugContentType("text/csv", false, false, "comma separated values", VisualConstants.ICON_TYPE_TABLE, "csv");
        manager.plugContentType("application/cel", true, false, "Affymetrix CEL", VisualConstants.ICON_TYPE_RAWDATA, "cel");
        manager.plugContentType("text/plain", false, false, "plain text", VisualConstants.ICON_TYPE_TEXT, "txt", "dat", "wee");
        manager.plugContentType("application/octet-stream", false, true, "binary", VisualConstants.ICON_TYPE_BINARY, "");
    }

    static {
        try {
            Properties version = new Properties();
            version.load(ApplicationConstants.class.getResourceAsStream("/version.number"));
            Properties build = new Properties();
            build.load(ApplicationConstants.class.getResourceAsStream("/build.number"));
            NAMI_VERSION = version.getProperty("version.number") + " (build " + build.getProperty("build.number") + ")";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        APPLICATION_TITLE = "Chipster v" + NAMI_VERSION;
        MAX_JOBS = Integer.parseInt(MicroarrayConfiguration.getValue("client", "max_jobs"));
        MAX_JOB_SIZE = Long.parseLong(MicroarrayConfiguration.getValue("client", "max_job_size"));
    }
}

