/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.i18n.Strings;
import abbot.tester.ComponentLocation;
import abbot.tester.JTableTester;
import abbot.tester.LocationUnavailableException;
import abbot.util.ExtendedComparator;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.JTable;

public class JTableLocation
extends ComponentLocation {
    protected String value = null;
    protected Cell cell = null;

    public JTableLocation() {
    }

    public JTableLocation(String value) {
        this.value = value;
    }

    public JTableLocation(int row, int col) {
        if (row < 0 || col < 0) {
            String msg = Strings.get("tester.JTable.invalid_cell", new Object[]{new Integer(row), new Integer(col)});
            throw new LocationUnavailableException(msg);
        }
        this.cell = new Cell(row, col);
    }

    public JTableLocation(Point p) {
        super(p);
    }

    protected String badFormat(String encoded) {
        return Strings.get("location.table.bad_format", new Object[]{encoded});
    }

    protected Point cellToPoint(JTable table, int row, int col) {
        if (row < 0 || row >= table.getRowCount() || col < 0 || col >= table.getColumnCount()) {
            String msg = Strings.get("tester.JTable.invalid_cell", new Object[]{new Integer(row), new Integer(col)});
            throw new LocationUnavailableException(msg);
        }
        Rectangle rect = this.getCellBounds(table, row, col);
        return new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    protected Rectangle getCellBounds(JTable table, int row, int col) {
        return table.getCellRect(row, col, false);
    }

    private Cell valueToCell(JTable table, String value) {
        for (int row = 0; row < table.getRowCount(); ++row) {
            for (int col = 0; col < table.getColumnCount(); ++col) {
                String str = JTableTester.valueToString(table, row, col);
                if (!ExtendedComparator.stringsMatch(value, str)) continue;
                return new Cell(row, col);
            }
        }
        String msg = Strings.get("tester.JTable.invalid_value", new Object[]{value});
        throw new LocationUnavailableException(msg);
    }

    public Point getPoint(Component c) {
        JTable table = (JTable)c;
        if (this.value != null) {
            Cell tmp = this.valueToCell(table, this.value);
            return this.cellToPoint(table, tmp.row, tmp.col);
        }
        if (this.cell != null) {
            return this.cellToPoint(table, this.cell.row, this.cell.col);
        }
        return super.getPoint(table);
    }

    public Cell getCell(JTable table) {
        if (this.value != null) {
            return this.valueToCell(table, this.value);
        }
        if (this.cell != null) {
            return new Cell(this.cell.row, this.cell.col);
        }
        Point where = super.getPoint(table);
        return new Cell(table.rowAtPoint(where), table.columnAtPoint(where));
    }

    public Rectangle getBounds(Component c) {
        JTable table = (JTable)c;
        Cell cell = this.getCell(table);
        if (cell == null) {
            String msg = Strings.get("tester.JTable.invalid_cell", new Object[]{new Integer(cell.row), new Integer(cell.col)});
            throw new LocationUnavailableException(msg);
        }
        return this.getCellBounds(table, cell.row, cell.col);
    }

    public boolean equals(Object o) {
        if (o instanceof JTableLocation) {
            JTableLocation loc = (JTableLocation)o;
            if (this.value != null) {
                return this.value.equals(loc.value);
            }
            if (this.cell != null) {
                return this.cell.equals(loc.cell);
            }
        }
        return super.equals(o);
    }

    public String toString() {
        if (this.value != null) {
            return this.encodeValue(this.value);
        }
        if (this.cell != null) {
            return this.cell.toString();
        }
        return super.toString();
    }

    public ComponentLocation parse(String encoded) {
        if (this.isValue(encoded = encoded.trim())) {
            this.value = this.parseValue(encoded);
            return this;
        }
        if (this.isIndex(encoded)) {
            String num = encoded.substring(1, encoded.length() - 1).trim();
            StringTokenizer st = new StringTokenizer(num, ",");
            try {
                int r = Integer.parseInt(st.nextToken().trim());
                int c = Integer.parseInt(st.nextToken().trim());
                this.cell = new Cell(r, c);
                return this;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(this.badFormat(encoded));
            }
        }
        return super.parse(encoded);
    }

    public static class Cell {
        public int row;
        public int col;

        public Cell(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public boolean equals(Object o) {
            return o instanceof Cell && ((Cell)o).row == this.row && ((Cell)o).col == this.col;
        }

        public String toString() {
            return "[" + this.row + "," + this.col + "]";
        }
    }
}

