/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.Platform;
import abbot.editor.recorder.JComponentRecorder;
import abbot.script.Action;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Step;
import abbot.tester.ComponentLocation;
import abbot.tester.JTabbedPaneLocation;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

public class JTabbedPaneRecorder
extends JComponentRecorder {
    private JTabbedPane tabbedPane;
    static /* synthetic */ Class class$javax$swing$JTabbedPane;

    public JTabbedPaneRecorder(Resolver resolver) {
        super(resolver);
    }

    public boolean accept(AWTEvent event) {
        if (this.isClick(event)) {
            MouseEvent me = (MouseEvent)event;
            this.tabbedPane = (JTabbedPane)me.getComponent();
            JTabbedPane tp = this.tabbedPane;
            TabbedPaneUI ui = tp.getUI();
            int index = ui.tabForCoordinate(tp, me.getX(), me.getY());
            if (index != -1) {
                this.setStatus("Selecting tab '" + tp.getTitleAt(index));
                this.init(3);
                return true;
            }
            if (Platform.isOSX()) {
                int xmin = tp.getWidth();
                int xmax = 0;
                int ymin = tp.getHeight();
                int ymax = 0;
                for (int i = 0; i < tp.getTabCount(); ++i) {
                    Rectangle rect = ui.getTabBounds(tp, i);
                    if (rect.x < 0) continue;
                    xmin = Math.min(rect.x, xmin);
                    xmax = Math.max(rect.x + rect.width, xmax);
                    ymin = Math.min(rect.y, ymin);
                    ymax = Math.max(rect.y + rect.height, ymax);
                }
                if (me.getX() > xmax && me.getX() < tp.getWidth() - xmin && me.getY() >= ymin && me.getY() <= ymax) {
                    this.init(2);
                    return true;
                }
            }
        }
        return super.accept(event);
    }

    protected Step createMenuSelection(Component menuItem) {
        ComponentReference ref = this.getResolver().addComponent(this.tabbedPane);
        JTabbedPaneLocation loc = new JTabbedPaneLocation(((JMenuItem)menuItem).getText());
        Action step = new Action(this.getResolver(), null, "actionSelectTab", new String[]{ref.getID(), ((ComponentLocation)loc).toString()});
        return step;
    }

    protected Step createClick(Component target, int x, int y, int mods, int count) {
        ComponentReference cr = this.getResolver().addComponent(target);
        JTabbedPane tp = (JTabbedPane)target;
        TabbedPaneUI ui = tp.getUI();
        int index = ui.tabForCoordinate(tp, x, y);
        if (index != -1) {
            return new Action(this.getResolver(), null, "actionSelectTab", new String[]{cr.getID(), this.getLocationArgument(tp, x, y)}, class$javax$swing$JTabbedPane == null ? (class$javax$swing$JTabbedPane = JTabbedPaneRecorder.class$("javax.swing.JTabbedPane")) : class$javax$swing$JTabbedPane);
        }
        return super.createClick(target, x, y, mods, count);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

