/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class NIOOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 8192;
    private final WritableByteChannel out;
    private final byte[] buffer;
    private final ByteBuffer byteBuffer;
    private int count;
    private boolean closed;

    public NIOOutputStream(WritableByteChannel out) {
        this(out, 8192);
    }

    public NIOOutputStream(WritableByteChannel out, int size) {
        this.out = out;
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buffer = new byte[size];
        this.byteBuffer = ByteBuffer.wrap(this.buffer);
    }

    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.availableBufferToWrite() < 1) {
            this.flush();
        }
        this.buffer[this.count++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (this.availableBufferToWrite() < len) {
            this.flush();
        }
        if (this.buffer.length >= len) {
            System.arraycopy(b, off, this.buffer, this.count, len);
            this.count += len;
        } else {
            this.write(ByteBuffer.wrap(b, off, len));
        }
    }

    public void flush() throws IOException {
        if (this.count > 0 && this.out != null) {
            this.byteBuffer.position(0);
            this.byteBuffer.limit(this.count);
            this.write(this.byteBuffer);
            this.count = 0;
        }
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    protected void checkClosed() throws IOException {
        if (this.closed) {
            throw new EOFException("Cannot write to the stream any more it has already been closed");
        }
    }

    private int availableBufferToWrite() {
        return this.buffer.length - this.count;
    }

    /*
     * Unable to fully structure code
     */
    protected void write(ByteBuffer data) throws IOException {
        remaining = data.remaining();
        lastRemaining = remaining - 1;
        delay = 1L;
        while (remaining > 0) {
            if (remaining == lastRemaining) {
                try {
                    Thread.sleep(delay);
                    if ((delay *= 2L) <= 1000L) ** GOTO lbl14
                    delay = 1000L;
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            } else {
                delay = 1L;
            }
lbl14:
            // 3 sources

            lastRemaining = remaining;
            this.out.write(data);
            remaining = data.remaining();
        }
    }
}

