/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.perf.PerfRate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerfConsumer
implements MessageListener {
    private static final Log LOG = LogFactory.getLog(PerfConsumer.class);
    protected Connection connection;
    protected MessageConsumer consumer;
    protected long sleepDuration;
    protected boolean enableAudit = false;
    protected ActiveMQMessageAudit audit = new ActiveMQMessageAudit(16384, 20);
    protected PerfRate rate = new PerfRate();

    public PerfConsumer(ConnectionFactory fac, Destination dest, String consumerName) throws JMSException {
        this.connection = fac.createConnection();
        this.connection.setClientID(consumerName);
        Session s = this.connection.createSession(false, 1);
        this.consumer = dest instanceof Topic && consumerName != null && consumerName.length() > 0 ? s.createDurableSubscriber((Topic)dest, consumerName) : s.createConsumer(dest);
        this.consumer.setMessageListener(this);
    }

    public PerfConsumer(ConnectionFactory fac, Destination dest) throws JMSException {
        this(fac, dest, null);
    }

    public void start() throws JMSException {
        this.connection.start();
        this.rate.reset();
    }

    public void stop() throws JMSException {
        this.connection.stop();
    }

    public void shutDown() throws JMSException {
        this.connection.close();
    }

    public PerfRate getRate() {
        return this.rate;
    }

    public void onMessage(Message msg) {
        this.rate.increment();
        try {
            if (this.enableAudit && !this.audit.isInOrder(msg.getJMSMessageID())) {
                LOG.error("Message out of order!!" + msg);
            }
            if (this.enableAudit && this.audit.isDuplicate(msg)) {
                LOG.error("Duplicate Message!" + msg);
            }
        }
        catch (JMSException e1) {
            e1.printStackTrace();
        }
        try {
            if (this.sleepDuration != 0L) {
                Thread.sleep(this.sleepDuration);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized long getSleepDuration() {
        return this.sleepDuration;
    }

    public synchronized void setSleepDuration(long sleepDuration) {
        this.sleepDuration = sleepDuration;
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public void setEnableAudit(boolean doAudit) {
        this.enableAudit = doAudit;
    }
}

