/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsMessage;

public class AdvisoryConsumerExample
extends ContextTestSupport {
    public void testWorks() throws Exception {
        this.template.sendBody("activemq:NewQueue." + System.currentTimeMillis(), (Object)"<hello>world!</hello>");
        Thread.sleep(10000L);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("activemq:InitialQueue").to("log:Messages");
                this.from("activemq:topic:ActiveMQ.Advisory.Queue?cacheLevelName=CACHE_CONSUMER").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ActiveMQMessage activeMQMessage;
                        DataStructure structure;
                        JmsMessage jmsMessage;
                        javax.jms.Message value;
                        Message in = exchange.getIn();
                        if (in instanceof JmsMessage && (value = (jmsMessage = (JmsMessage)in).getJmsMessage()) instanceof ActiveMQMessage && (structure = (activeMQMessage = (ActiveMQMessage)value).getDataStructure()) instanceof DestinationInfo) {
                            DestinationInfo destinationInfo = (DestinationInfo)structure;
                            System.out.println("Received: " + destinationInfo);
                        }
                    }
                });
            }
        };
    }
}

