/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component;

import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.component.validator.ValidatorComponent;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public abstract class ResourceBasedEndpoint
extends ProcessorEndpoint {
    protected static final transient Log LOG = LogFactory.getLog(ValidatorComponent.class);
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final String resourceUri;
    private Resource resource;

    public ResourceBasedEndpoint(String endpointUri, Component component, String resourceUri, Processor processor) {
        super(endpointUri, component, processor);
        this.resourceUri = resourceUri;
    }

    public Resource getResource() {
        if (this.resource == null) {
            this.resource = this.getResourceLoader().getResource(this.resourceUri);
            if (this.resource == null) {
                throw new IllegalArgumentException("Could not find resource for URI: " + this.resourceUri + " using: " + this.getResourceLoader());
            }
        }
        return this.resource;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

