/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.converter.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;

public class ReportingTypeConverterLoader
extends AnnotationTypeConverterLoader {
    private static final Comparator<TypeMapping> COMPARE_LAST_LOADED_FIRST = new Comparator<TypeMapping>(){

        @Override
        public int compare(TypeMapping t1, TypeMapping t2) {
            if (ObjectHelper.equal(t1.fromType, t2.fromType)) {
                return ObjectHelper.equal(t1.toType, t2.toType) ? t1.index - t2.index : ObjectHelper.compare(ReportingTypeConverterLoader.getTypeName(t1.toType), ReportingTypeConverterLoader.getTypeName(t2.toType));
            }
            return ObjectHelper.compare(ReportingTypeConverterLoader.getTypeName(t1.fromType), ReportingTypeConverterLoader.getTypeName(t2.fromType));
        }
    };
    private List<TypeMapping> typeMappings = new ArrayList<TypeMapping>();

    public TypeMapping[] getTypeConversions() {
        Collections.sort(this.typeMappings, COMPARE_LAST_LOADED_FIRST);
        return this.typeMappings.toArray(new TypeMapping[this.typeMappings.size()]);
    }

    protected void registerTypeConverter(TypeConverterRegistry registry, Method method, Class toType, Class fromType, TypeConverter typeConverter) {
        TypeMapping mapping = new TypeMapping(toType, fromType, typeConverter.getClass(), method);
        this.typeMappings.add(mapping);
    }

    private static String getTypeName(Class type) {
        return type != null ? type.getName() : null;
    }

    public static class TypeMapping {
        private static int counter;
        Class toType;
        Class fromType;
        Class converterType;
        Method method;
        int index;

        public TypeMapping(Class toType, Class fromType, Class converterType, Method method) {
            this.toType = toType;
            this.fromType = fromType;
            this.converterType = converterType;
            this.method = method;
            this.index = counter++;
        }

        public Class getFromType() {
            return this.fromType;
        }

        public Class getToType() {
            return this.toType;
        }

        public Class getConverterType() {
            return this.converterType;
        }

        public Method getMethod() {
            return this.method;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object object) {
            if (object instanceof TypeMapping) {
                TypeMapping that = (TypeMapping)object;
                return this.index == that.index;
            }
            return false;
        }

        public int hashCode() {
            int answer = this.toType.hashCode();
            if (this.fromType != null) {
                answer *= 37 + this.fromType.hashCode();
            }
            return answer;
        }

        public String toString() {
            return "[" + this.fromType.getSimpleName() + "=>" + this.toType.getSimpleName() + "]";
        }
    }
}

