/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeProcessor
extends ServiceSupport
implements Processor {
    private final Collection<Processor> processors;

    public CompositeProcessor(Collection<Processor> processors) {
        this.processors = processors;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        for (Processor processor : this.processors) {
            processor.process(exchange);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[ ");
        boolean first = true;
        for (Processor processor : this.processors) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(processor.toString());
        }
        builder.append(" ]");
        return builder.toString();
    }

    public Collection<Processor> getProcessors() {
        return this.processors;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processors);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processors);
    }
}

