/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect;

import java.util.Arrays;
import org.fest.reflect.ReflectionError;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Method<T> {
    private final Object target;
    private final java.lang.reflect.Method method;
    private final boolean accessible;

    Method(String methodName, Object target, Class<?> ... parameterTypes) {
        this.target = target;
        this.method = Method.method(methodName, target.getClass(), parameterTypes);
        this.accessible = this.method.isAccessible();
    }

    private static java.lang.reflect.Method method(String methodName, Class<?> type, Class<?>[] parameterTypes) {
        try {
            return type.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to find method with name ", Strings.quote((String)methodName), " in type ", type.getName(), " with parameter types ", Arrays.toString(parameterTypes)}));
        }
    }

    public T invoke(Object ... args) {
        try {
            this.method.setAccessible(true);
            Object object = this.method.invoke(this.target, args);
            return (T)object;
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to invoke method ", Strings.quote((String)this.method.getName()), " with arguments ", Arrays.toString(args)}));
        }
        finally {
            this.method.setAccessible(this.accessible);
        }
    }

    public java.lang.reflect.Method info() {
        return this.method;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParameterTypes<T> {
        private final Class<?>[] values;
        private final ReturnType<T> returnType;

        ParameterTypes(Class<?>[] parameterTypes, ReturnType<T> returnType) {
            this.values = parameterTypes;
            this.returnType = returnType;
        }

        public Method<T> in(Object target) {
            return new Method(((ReturnType)this.returnType).fieldName.name, target, this.values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReturnType<T> {
        private final MethodName fieldName;

        ReturnType(Class<T> type, MethodName fieldName) {
            this.fieldName = fieldName;
        }

        public Method<T> in(Object target) {
            return new Method(this.fieldName.name, target, new Class[0]);
        }

        public ParameterTypes<T> withParameterTypes(Class<?> ... parameterTypes) {
            return new ParameterTypes(parameterTypes, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodName {
        private final String name;

        MethodName(String name) {
            this.name = name;
        }

        public <T> ReturnType<T> withReturnType(Class<T> type) {
            return new ReturnType<T>(type, this);
        }

        public ParameterTypes<Void> withParameterTypes(Class<?> ... parameterTypes) {
            ReturnType<Void> returnType = new ReturnType<Void>(Void.class, this);
            return new ParameterTypes<Void>(parameterTypes, returnType);
        }

        public Method<Void> in(Object target) {
            return new Method<Void>(this.name, target, new Class[0]);
        }
    }
}

