/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test;

import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.test.JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsTopicSendReceiveWithEmbeddedBrokerAndUserIDTest
extends JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest {
    private static final Log LOG = LogFactory.getLog(JmsTopicSendReceiveWithEmbeddedBrokerAndUserIDTest.class);
    protected String userName = "James";

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory answer = super.createConnectionFactory();
        answer.setUserName(this.userName);
        return answer;
    }

    protected void configureBroker(BrokerService answer) throws Exception {
        answer.setPopulateJMSXUserID(true);
        super.configureBroker(answer);
    }

    protected void assertMessagesReceivedAreValid(List receivedMessages) throws JMSException {
        super.assertMessagesReceivedAreValid(receivedMessages);
        for (Message message : receivedMessages) {
            String userID = message.getStringProperty("JMSXUserID");
            LOG.info((Object)("Received message with userID: " + userID));
            JmsTopicSendReceiveWithEmbeddedBrokerAndUserIDTest.assertEquals((String)"JMSXUserID header", (String)this.userName, (String)userID);
        }
    }
}

