/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;
import org.apache.activemq.kaha.impl.index.VMIndexLinkedList;

public class VMIndexLinkedListTest
extends TestCase {
    static final int NUMBER = 30;
    private IndexItem root;
    private List<IndexItem> testData = new ArrayList<IndexItem>();
    private IndexLinkedList list;

    protected void setUp() throws Exception {
        super.setUp();
        IndexItem item = new IndexItem();
        this.list = this.createList(item);
        this.root = this.list.getRoot();
        for (int i = 0; i < 30; ++i) {
            item = this.createIndex(this.list, i);
            this.testData.add(item);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.testData.clear();
        this.list = null;
    }

    IndexItem createIndex(IndexLinkedList list, int offset) throws IOException {
        IndexItem result = new IndexItem();
        result.setOffset((long)offset);
        return result;
    }

    protected IndexLinkedList createList(IndexItem root) throws IOException {
        return new VMIndexLinkedList(root);
    }

    protected void addToList(IndexLinkedList list, IndexItem item) throws IOException {
        list.add(item);
    }

    protected void insertToList(IndexLinkedList list, int pos, IndexItem item) throws IOException {
        list.add(pos, item);
    }

    protected void insertFirst(IndexLinkedList list, IndexItem item) throws IOException {
        list.addFirst(item);
    }

    protected synchronized void remove(IndexLinkedList list, IndexItem item) throws IOException {
        IndexItem root = list.getRoot();
        IndexItem prev = list.getPrevEntry(item);
        IndexItem next = list.getNextEntry(item);
        list.remove(item);
    }

    public void testGetFirst() throws IOException {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
        }
        VMIndexLinkedListTest.assertNotNull((Object)this.list.getFirst());
        VMIndexLinkedListTest.assertTrue((boolean)this.list.getFirst().equals((Object)this.testData.get(0)));
    }

    public void testGetLast() throws IOException {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
        }
        VMIndexLinkedListTest.assertTrue((this.list.getLast() == this.testData.get(this.testData.size() - 1) ? 1 : 0) != 0);
    }

    public void testRemoveFirst() throws IOException {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
        }
        VMIndexLinkedListTest.assertTrue((boolean)this.list.removeFirst().equals(this.testData.get(0)));
    }

    public void testRemoveLast() throws IOException {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
        }
        VMIndexLinkedListTest.assertTrue((boolean)this.list.removeLast().equals(this.testData.get(this.testData.size() - 1)));
    }

    public void testAddFirst() throws IOException {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.insertFirst(this.list, this.testData.get(i));
        }
        int count = 0;
        for (int i = this.testData.size() - 1; i >= 0; --i) {
            VMIndexLinkedListTest.assertTrue((boolean)this.testData.get(i).equals((Object)this.list.get(count++)));
        }
    }

    public void testAddLast() throws IOException {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            VMIndexLinkedListTest.assertTrue((boolean)this.testData.get(i).equals((Object)this.list.get(i)));
        }
    }

    public void testSize() throws IOException {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
            VMIndexLinkedListTest.assertTrue((this.list.size() == i + 1 ? 1 : 0) != 0);
        }
    }

    public void testIsEmpty() throws IOException {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
            VMIndexLinkedListTest.assertTrue((this.list.size() == i + 1 ? 1 : 0) != 0);
        }
        this.list.clear();
        VMIndexLinkedListTest.assertTrue((boolean)this.list.isEmpty());
    }

    public void testAddIndexItem() throws IOException {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            VMIndexLinkedListTest.assertTrue((boolean)this.testData.get(i).equals((Object)this.list.get(i)));
        }
    }

    public void testClear() throws IOException {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
            VMIndexLinkedListTest.assertTrue((this.list.size() == i + 1 ? 1 : 0) != 0);
        }
        this.list.clear();
        VMIndexLinkedListTest.assertTrue((boolean)this.list.isEmpty());
    }

    public void testAddIntIndexItem() throws IOException {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.insertToList(this.list, i, this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            VMIndexLinkedListTest.assertTrue((boolean)this.testData.get(i).equals((Object)this.list.get(i)));
        }
    }

    public void testRemoveInt() throws IOException {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.insertToList(this.list, i, this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.remove(0);
        }
        VMIndexLinkedListTest.assertTrue((boolean)this.list.isEmpty());
        for (i = 0; i < this.testData.size(); ++i) {
            this.insertToList(this.list, i, this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.remove(this.list.size() - 1);
        }
        VMIndexLinkedListTest.assertTrue((boolean)this.list.isEmpty());
    }

    public void testIndexOf() throws IOException {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            VMIndexLinkedListTest.assertTrue((this.list.indexOf((StoreEntry)this.testData.get(i)) == i ? 1 : 0) != 0);
        }
    }

    public void testGetNextEntry() throws IOException {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
        }
        IndexItem next = this.list.getFirst();
        int count = 0;
        while (next != null) {
            VMIndexLinkedListTest.assertTrue((boolean)next.equals((Object)this.testData.get(count++)));
            next = this.list.getNextEntry(next);
            VMIndexLinkedListTest.assertTrue((next == null || !next.equals((Object)this.root) ? 1 : 0) != 0);
        }
    }

    public void testGetPrevEntry() throws IOException {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
        }
        IndexItem next = this.list.getLast();
        int count = this.testData.size() - 1;
        while (next != null) {
            VMIndexLinkedListTest.assertTrue((boolean)next.equals((Object)this.testData.get(count--)));
            next = this.list.getPrevEntry(next);
            VMIndexLinkedListTest.assertTrue((next == null || !next.equals((Object)this.root) ? 1 : 0) != 0);
        }
    }

    public void testRemoveIndexItem() throws IOException {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.addToList(this.list, this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.remove(this.testData.get(i));
            VMIndexLinkedListTest.assertTrue((this.list.size() == this.testData.size() - i - 1 ? 1 : 0) != 0);
        }
    }

    public void testAddRemove() throws IOException {
        IndexItem a = this.createIndex(this.list, 0);
        this.addToList(this.list, a);
        IndexItem b = this.createIndex(this.list, 1);
        this.addToList(this.list, b);
        IndexItem c = this.createIndex(this.list, 2);
        this.addToList(this.list, c);
        IndexItem d = this.createIndex(this.list, 3);
        this.addToList(this.list, d);
        this.remove(this.list, d);
        VMIndexLinkedListTest.assertTrue((boolean)this.list.getLast().equals((Object)c));
        VMIndexLinkedListTest.assertTrue((boolean)this.list.getNextEntry(b).equals((Object)c));
        this.remove(this.list, b);
        VMIndexLinkedListTest.assertTrue((boolean)this.list.getNextEntry(a).equals((Object)c));
        VMIndexLinkedListTest.assertTrue((boolean)this.list.getLast().equals((Object)c));
    }
}

