/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQMapMessageTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(ActiveMQMapMessageTest.class);
    private String name = "testName";

    public ActiveMQMapMessageTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(ActiveMQMapMessageTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBytesConversion() throws JMSException, IOException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setBoolean("boolean", true);
        msg.setByte("byte", (byte)1);
        msg.setBytes("bytes", new byte[1]);
        msg.setChar("char", 'a');
        msg.setDouble("double", 1.5);
        msg.setFloat("float", 1.5f);
        msg.setInt("int", 1);
        msg.setLong("long", 1L);
        msg.setObject("object", (Object)"stringObj");
        msg.setShort("short", (short)1);
        msg.setString("string", "string");
        StringBuffer bigSB = new StringBuffer(0x100000);
        for (int i = 0; i < 0x100000; ++i) {
            bigSB.append(97 + i % 26);
        }
        String bigString = bigSB.toString();
        msg.setString("bigString", bigString);
        msg = (ActiveMQMapMessage)msg.copy();
        ActiveMQMapMessageTest.assertEquals((boolean)msg.getBoolean("boolean"), (boolean)true);
        ActiveMQMapMessageTest.assertEquals((byte)msg.getByte("byte"), (byte)1);
        ActiveMQMapMessageTest.assertEquals((int)msg.getBytes("bytes").length, (int)1);
        ActiveMQMapMessageTest.assertEquals((char)msg.getChar("char"), (char)'a');
        ActiveMQMapMessageTest.assertEquals((double)msg.getDouble("double"), (double)1.5, (double)0.0);
        ActiveMQMapMessageTest.assertEquals((float)msg.getFloat("float"), (float)1.5f, (float)0.0f);
        ActiveMQMapMessageTest.assertEquals((int)msg.getInt("int"), (int)1);
        ActiveMQMapMessageTest.assertEquals((long)msg.getLong("long"), (long)1L);
        ActiveMQMapMessageTest.assertEquals((Object)msg.getObject("object"), (Object)"stringObj");
        ActiveMQMapMessageTest.assertEquals((short)msg.getShort("short"), (short)1);
        ActiveMQMapMessageTest.assertEquals((String)msg.getString("string"), (String)"string");
        ActiveMQMapMessageTest.assertEquals((String)msg.getString("bigString"), (String)bigString);
    }

    public void testGetBoolean() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setBoolean(this.name, true);
        msg.setReadOnlyBody(true);
        ActiveMQMapMessageTest.assertTrue((boolean)msg.getBoolean(this.name));
        msg.clearBody();
        msg.setString(this.name, "true");
        msg = (ActiveMQMapMessage)msg.copy();
        ActiveMQMapMessageTest.assertTrue((boolean)msg.getBoolean(this.name));
    }

    public void testGetByte() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setByte(this.name, (byte)1);
        msg = (ActiveMQMapMessage)msg.copy();
        ActiveMQMapMessageTest.assertTrue((msg.getByte(this.name) == 1 ? 1 : 0) != 0);
    }

    public void testGetShort() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            msg.setShort(this.name, (short)1);
            msg = (ActiveMQMapMessage)msg.copy();
            ActiveMQMapMessageTest.assertTrue((msg.getShort(this.name) == 1 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetChar() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            msg.setChar(this.name, 'a');
            msg = (ActiveMQMapMessage)msg.copy();
            ActiveMQMapMessageTest.assertTrue((msg.getChar(this.name) == 'a' ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetInt() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            msg.setInt(this.name, 1);
            msg = (ActiveMQMapMessage)msg.copy();
            ActiveMQMapMessageTest.assertTrue((msg.getInt(this.name) == 1 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetLong() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            msg.setLong(this.name, 1L);
            msg = (ActiveMQMapMessage)msg.copy();
            ActiveMQMapMessageTest.assertTrue((msg.getLong(this.name) == 1L ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetFloat() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            msg.setFloat(this.name, 1.5f);
            msg = (ActiveMQMapMessage)msg.copy();
            ActiveMQMapMessageTest.assertTrue((msg.getFloat(this.name) == 1.5f ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetDouble() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            msg.setDouble(this.name, 1.5);
            msg = (ActiveMQMapMessage)msg.copy();
            ActiveMQMapMessageTest.assertTrue((msg.getDouble(this.name) == 1.5 ? 1 : 0) != 0);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetString() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            String str = "test";
            msg.setString(this.name, str);
            msg = (ActiveMQMapMessage)msg.copy();
            ActiveMQMapMessageTest.assertEquals((String)msg.getString(this.name), (String)str);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetBytes() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        try {
            byte[] bytes1 = new byte[3];
            byte[] bytes2 = new byte[2];
            System.arraycopy(bytes1, 0, bytes2, 0, 2);
            msg.setBytes(this.name, bytes1);
            msg.setBytes(this.name + "2", bytes1, 0, 2);
            msg = (ActiveMQMapMessage)msg.copy();
            ActiveMQMapMessageTest.assertTrue((boolean)Arrays.equals(msg.getBytes(this.name), bytes1));
            ActiveMQMapMessageTest.assertEquals((int)msg.getBytes(this.name + "2").length, (int)bytes2.length);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageTest.assertTrue((boolean)false);
        }
    }

    public void testGetObject() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        Boolean booleanValue = Boolean.TRUE;
        Byte byteValue = Byte.valueOf("1");
        byte[] bytesValue = new byte[3];
        Character charValue = new Character('a');
        Double doubleValue = Double.valueOf("1.5");
        Float floatValue = Float.valueOf("1.5");
        Integer intValue = Integer.valueOf("1");
        Long longValue = Long.valueOf("1");
        Short shortValue = Short.valueOf("1");
        String stringValue = "string";
        try {
            msg.setObject("boolean", (Object)booleanValue);
            msg.setObject("byte", (Object)byteValue);
            msg.setObject("bytes", (Object)bytesValue);
            msg.setObject("char", (Object)charValue);
            msg.setObject("double", (Object)doubleValue);
            msg.setObject("float", (Object)floatValue);
            msg.setObject("int", (Object)intValue);
            msg.setObject("long", (Object)longValue);
            msg.setObject("short", (Object)shortValue);
            msg.setObject("string", (Object)stringValue);
        }
        catch (MessageFormatException mfe) {
            LOG.warn((Object)("Caught: " + (Object)((Object)mfe)));
            mfe.printStackTrace();
            ActiveMQMapMessageTest.fail((String)"object formats should be correct");
        }
        msg = (ActiveMQMapMessage)msg.copy();
        ActiveMQMapMessageTest.assertTrue((boolean)(msg.getObject("boolean") instanceof Boolean));
        ActiveMQMapMessageTest.assertEquals((Object)msg.getObject("boolean"), (Object)booleanValue);
        ActiveMQMapMessageTest.assertEquals((boolean)msg.getBoolean("boolean"), (boolean)booleanValue);
        ActiveMQMapMessageTest.assertTrue((boolean)(msg.getObject("byte") instanceof Byte));
        ActiveMQMapMessageTest.assertEquals((Object)msg.getObject("byte"), (Object)byteValue);
        ActiveMQMapMessageTest.assertEquals((byte)msg.getByte("byte"), (byte)byteValue);
        ActiveMQMapMessageTest.assertTrue((boolean)(msg.getObject("bytes") instanceof byte[]));
        ActiveMQMapMessageTest.assertEquals((int)((byte[])msg.getObject("bytes")).length, (int)bytesValue.length);
        ActiveMQMapMessageTest.assertEquals((int)msg.getBytes("bytes").length, (int)bytesValue.length);
        ActiveMQMapMessageTest.assertTrue((boolean)(msg.getObject("char") instanceof Character));
        ActiveMQMapMessageTest.assertEquals((Object)msg.getObject("char"), (Object)charValue);
        ActiveMQMapMessageTest.assertEquals((char)msg.getChar("char"), (char)charValue.charValue());
        ActiveMQMapMessageTest.assertTrue((boolean)(msg.getObject("double") instanceof Double));
        ActiveMQMapMessageTest.assertEquals((Object)msg.getObject("double"), (Object)doubleValue);
        ActiveMQMapMessageTest.assertEquals((double)msg.getDouble("double"), (double)doubleValue, (double)0.0);
        ActiveMQMapMessageTest.assertTrue((boolean)(msg.getObject("float") instanceof Float));
        ActiveMQMapMessageTest.assertEquals((Object)msg.getObject("float"), (Object)floatValue);
        ActiveMQMapMessageTest.assertEquals((float)msg.getFloat("float"), (float)floatValue.floatValue(), (float)0.0f);
        ActiveMQMapMessageTest.assertTrue((boolean)(msg.getObject("int") instanceof Integer));
        ActiveMQMapMessageTest.assertEquals((Object)msg.getObject("int"), (Object)intValue);
        ActiveMQMapMessageTest.assertEquals((int)msg.getInt("int"), (int)intValue);
        ActiveMQMapMessageTest.assertTrue((boolean)(msg.getObject("long") instanceof Long));
        ActiveMQMapMessageTest.assertEquals((Object)msg.getObject("long"), (Object)longValue);
        ActiveMQMapMessageTest.assertEquals((long)msg.getLong("long"), (long)longValue);
        ActiveMQMapMessageTest.assertTrue((boolean)(msg.getObject("short") instanceof Short));
        ActiveMQMapMessageTest.assertEquals((Object)msg.getObject("short"), (Object)shortValue);
        ActiveMQMapMessageTest.assertEquals((short)msg.getShort("short"), (short)shortValue);
        ActiveMQMapMessageTest.assertTrue((boolean)(msg.getObject("string") instanceof String));
        ActiveMQMapMessageTest.assertEquals((Object)msg.getObject("string"), (Object)stringValue);
        ActiveMQMapMessageTest.assertEquals((String)msg.getString("string"), (String)stringValue);
        msg.clearBody();
        try {
            msg.setObject("object", new Object());
            ActiveMQMapMessageTest.fail((String)"should have thrown exception");
        }
        catch (MessageFormatException e) {
            // empty catch block
        }
    }

    public void testGetMapNames() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setBoolean("boolean", true);
        msg.setByte("byte", (byte)1);
        msg.setBytes("bytes1", new byte[1]);
        msg.setBytes("bytes2", new byte[3], 0, 2);
        msg.setChar("char", 'a');
        msg.setDouble("double", 1.5);
        msg.setFloat("float", 1.5f);
        msg.setInt("int", 1);
        msg.setLong("long", 1L);
        msg.setObject("object", (Object)"stringObj");
        msg.setShort("short", (short)1);
        msg.setString("string", "string");
        msg = (ActiveMQMapMessage)msg.copy();
        Enumeration mapNamesEnum = msg.getMapNames();
        ArrayList mapNamesList = Collections.list(mapNamesEnum);
        ActiveMQMapMessageTest.assertEquals((int)mapNamesList.size(), (int)12);
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("boolean"));
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("byte"));
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("bytes1"));
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("bytes2"));
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("char"));
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("double"));
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("float"));
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("int"));
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("long"));
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("object"));
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("short"));
        ActiveMQMapMessageTest.assertTrue((boolean)mapNamesList.contains("string"));
    }

    public void testItemExists() throws JMSException {
        ActiveMQMapMessage mapMessage = new ActiveMQMapMessage();
        mapMessage.setString("exists", "test");
        mapMessage = (ActiveMQMapMessage)mapMessage.copy();
        ActiveMQMapMessageTest.assertTrue((boolean)mapMessage.itemExists("exists"));
        ActiveMQMapMessageTest.assertFalse((boolean)mapMessage.itemExists("doesntExist"));
    }

    public void testClearBody() throws JMSException {
        ActiveMQMapMessage mapMessage = new ActiveMQMapMessage();
        mapMessage.setString("String", "String");
        mapMessage.clearBody();
        ActiveMQMapMessageTest.assertFalse((boolean)mapMessage.isReadOnlyBody());
        mapMessage.onSend();
        mapMessage.setContent(mapMessage.getContent());
        ActiveMQMapMessageTest.assertNull((Object)mapMessage.getString("String"));
        mapMessage.clearBody();
        mapMessage.setString("String", "String");
        mapMessage = (ActiveMQMapMessage)mapMessage.copy();
        mapMessage.getString("String");
    }

    public void testReadOnlyBody() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setBoolean("boolean", true);
        msg.setByte("byte", (byte)1);
        msg.setBytes("bytes", new byte[1]);
        msg.setBytes("bytes2", new byte[3], 0, 2);
        msg.setChar("char", 'a');
        msg.setDouble("double", 1.5);
        msg.setFloat("float", 1.5f);
        msg.setInt("int", 1);
        msg.setLong("long", 1L);
        msg.setObject("object", (Object)"stringObj");
        msg.setShort("short", (short)1);
        msg.setString("string", "string");
        msg.setReadOnlyBody(true);
        try {
            msg.getBoolean("boolean");
            msg.getByte("byte");
            msg.getBytes("bytes");
            msg.getChar("char");
            msg.getDouble("double");
            msg.getFloat("float");
            msg.getInt("int");
            msg.getLong("long");
            msg.getObject("object");
            msg.getShort("short");
            msg.getString("string");
        }
        catch (MessageNotReadableException mnre) {
            ActiveMQMapMessageTest.fail((String)"should be readable");
        }
        try {
            msg.setBoolean("boolean", true);
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setByte("byte", (byte)1);
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setBytes("bytes", new byte[1]);
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setBytes("bytes2", new byte[3], 0, 2);
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setChar("char", 'a');
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setDouble("double", 1.5);
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setFloat("float", 1.5f);
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setInt("int", 1);
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setLong("long", 1L);
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setObject("object", (Object)"stringObj");
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setShort("short", (short)1);
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            msg.setString("string", "string");
            ActiveMQMapMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }

    public void testWriteOnlyBody() throws JMSException {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        msg.setReadOnlyBody(false);
        msg.setBoolean("boolean", true);
        msg.setByte("byte", (byte)1);
        msg.setBytes("bytes", new byte[1]);
        msg.setBytes("bytes2", new byte[3], 0, 2);
        msg.setChar("char", 'a');
        msg.setDouble("double", 1.5);
        msg.setFloat("float", 1.5f);
        msg.setInt("int", 1);
        msg.setLong("long", 1L);
        msg.setObject("object", (Object)"stringObj");
        msg.setShort("short", (short)1);
        msg.setString("string", "string");
        msg.setReadOnlyBody(true);
        msg.getBoolean("boolean");
        msg.getByte("byte");
        msg.getBytes("bytes");
        msg.getChar("char");
        msg.getDouble("double");
        msg.getFloat("float");
        msg.getInt("int");
        msg.getLong("long");
        msg.getObject("object");
        msg.getShort("short");
        msg.getString("string");
    }
}

