/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurableConsumerTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(DurableConsumerTest.class);
    private static int COUNT = 10240;
    private static String CONSUMER_NAME = "DURABLE_TEST";
    protected BrokerService broker;
    protected String bindAddress = "tcp://localhost:61616";
    protected byte[] payload = new byte[16384];
    protected ConnectionFactory factory;

    public void testConsumer() throws Exception {
        BytesMessage msg;
        int i;
        this.factory = this.createConnectionFactory();
        Connection consumerConnection = this.factory.createConnection();
        consumerConnection.setClientID(CONSUMER_NAME);
        Session consumerSession = consumerConnection.createSession(false, 1);
        Topic topic = consumerSession.createTopic(((Object)((Object)this)).getClass().getName());
        TopicSubscriber consumer = consumerSession.createDurableSubscriber(topic, CONSUMER_NAME);
        consumerConnection.start();
        consumerConnection.close();
        this.broker.stop();
        this.broker = this.createBroker(false);
        Connection producerConnection = this.factory.createConnection();
        Session producerSession = producerConnection.createSession(false, 1);
        MessageProducer producer = producerSession.createProducer((Destination)topic);
        producerConnection.start();
        for (i = 0; i < COUNT; ++i) {
            msg = producerSession.createBytesMessage();
            msg.writeBytes(this.payload);
            producer.send((Message)msg);
            if (i == 0 || i % 1000 != 0) continue;
            LOG.info((Object)("Sent msg " + i));
        }
        producerConnection.close();
        this.broker.stop();
        this.broker = this.createBroker(false);
        consumerConnection = this.factory.createConnection();
        consumerConnection.setClientID(CONSUMER_NAME);
        consumerSession = consumerConnection.createSession(false, 1);
        consumer = consumerSession.createDurableSubscriber(topic, CONSUMER_NAME);
        consumerConnection.start();
        for (i = 0; i < COUNT; ++i) {
            msg = consumer.receive(5000L);
            DurableConsumerTest.assertNotNull((String)("Missing message: " + i), (Object)msg);
            if (i == 0 || i % 1000 != 0) continue;
            LOG.info((Object)("Received msg " + i));
        }
        consumerConnection.close();
    }

    protected void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker(true);
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
            this.broker = null;
        }
    }

    protected Topic creatTopic(Session s, String destinationName) throws JMSException {
        return s.createTopic(destinationName);
    }

    protected BrokerService createBroker(boolean deleteStore) throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer, deleteStore);
        answer.start();
        return answer;
    }

    protected void configureBroker(BrokerService answer, boolean deleteStore) throws Exception {
        answer.setDeleteAllMessagesOnStartup(deleteStore);
        answer.addConnector(this.bindAddress);
        answer.setUseShutdownHook(false);
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.bindAddress);
    }
}

